/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import gov.va.med.ccht.model.CCHTAuditFields;

@Entity
@Table(schema="ht", name="ROLE_PERMISSION")
public class RolePermission extends CCHTAuditFields {

	private Long id;
	private Role role;
	private Permission permission;
	private boolean inactive = false; // not used in ciss but have db constraint

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name="ROLE_PERMISSION_ID",  unique = true, nullable = false)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	
	/**
	 * @return the permission
	 */
	@ManyToOne
	@JoinColumn(name="PERMISSION_ID")
	public Permission getPermission() {
		return permission;
	}

	/**
	 * @param permission
	 *            the permission to set
	 */
	public void setPermission(Permission permission) {
		this.permission = permission;
	}

	/**
	 * @return the role
	 */
	@ManyToOne
	@JoinColumn(name="ROLE_ID")
	public Role getRole() {
		return role;
	}

	/**
	 * @param role
	 *            the role to set
	 */
	public void setRole(Role role) {
		this.role = role;
	}

	/**
	 * @return the inactive
	 */
	@Transient
	public boolean isInactive() {
		return inactive;
	}

	/**
	 * @param inactive
	 *            the inactive to set
	 */
	public void setInactive(boolean inactive) {
		this.inactive = inactive;
	}
}
