package gov.va.med.fw.security;

//Java imports
import javax.crypto.SecretKey;

/**
 * This is the API clients uses for getting secret key, encrypting and
 * decrypting. Thsi class uses SunJCE provider to generate secret key,
 * encrypting and decrypting the information.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public interface EncryptionService {
	public static String CRYPTO_SUFFIX = "CRYPTO";

	/**
	 * Gets the encryption algorithm.
	 */
	public String getAlgorithm();

	/**
	 * Sets the encryption algorithm.
	 */
	public void setAlgorithm(String algorithm);

	/**
	 * Gets the key size from the configuration file.
	 */
	public int getKeySize();

	/**
	 * Gets the key size from the configuration file.
	 */
	public void setKeySize(int keySize);

	/**
	 * Checks to see the encryption is enabled or not.
	 */
	public boolean isEncryptionEnabled();

	/**
	 * Sets the encryption flag.
	 */
	public void setEncryptionFlag(boolean encryptionFlag);

	/**
	 * Gets the default Character Encoding.
	 */
	public String getDefaultCharacterEncoding();

	/**
	 * Sets the default Character Encoding.
	 */
	public void setDefaultCharacterEncoding(String defaultCharacterEncoding);

	/**
	 * Gets the KeyManager object.
	 */
	public KeyManager getKeyManager();

	/**
	 * Sets the KeyManager object.
	 */
	public void setKeyManager(KeyManager keyManager);

	/**
	 * Encrypt the given text using the given secret key.
	 * 
	 * @param key
	 *            the secret key
	 * @param clearText
	 *            the test to be encrypted
	 * @param characterEncoding
	 *            the character encoding
	 * @return the encrypted text
	 * @throws EncryptionServiceException
	 *             thrown when there was an encryption error
	 */
	public String encrypt(SecretKey key, String characterEncoding, String clearText)
			throws EncryptionServiceException;

	public String encrypt(SecretKey key, String characterEncoding, String clearText, String suffix)
			throws EncryptionServiceException;

	/**
	 * Decrypt the given text using the given secret key.
	 * 
	 * @param key
	 *            the secret key
	 * @param encryptedText
	 *            the encrypted text
	 * @param characterEncoding
	 *            the character encoding
	 * @return the decrypted text
	 * @throws DecryptionException
	 *             thrown when there was a decryption error
	 */
	public String decrypt(SecretKey key, String characterEncoding, String encryptedText)
			throws EncryptionServiceException;

	public String decrypt(SecretKey key, String characterEncoding, String encryptedText,
			String suffix) throws EncryptionServiceException;
}