/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import java.util.Collection;

import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

/**
 * Implementation of AuthenticationObject. Provide package protected setter
 * methods to set the loggedIn flag and UserPrincipal.
 * 
 * @author DNS
 * @date May 3, 2005 10:54:53 AM
 */
public class AuthenticationToken extends UsernamePasswordAuthenticationToken implements
		AuthenticationObject {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8639301379363192105L;
	private boolean loggedIn = false; // default value.
	private UserPrincipal userPrincipal = null;

	/**
	 * Constructor using principal and credentials.
	 * 
	 * @param principal
	 * @param credentials
	 */
	public AuthenticationToken(Object principal, Object credentials) {
		super(principal, credentials);
	}

	/**
	 * Constructor using principal, credentials and granted authorities.
	 * 
	 * @param principal
	 * @param credentials
	 * @param authorities
	 */
//	public AuthenticationToken(Object principal, Object credentials, GrantedAuthority[] authorities) {
//		super(principal, credentials, authorities);
//	}
	
	public AuthenticationToken(Object principal, Object credentials, Collection<GrantedAuthority> authorities) {
		super(principal, credentials, authorities);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.security.jaas.AuthenticationObject#isLoggedIn()
	 */
	public boolean isLoggedIn() {
		return loggedIn;
	}

	/**
	 * Set the loggedIn flag
	 */
	void setLoggedIn(boolean loggedIn) {
		this.loggedIn = loggedIn;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.security.jaas.AuthenticationObject#getUserPrincipal()
	 */
	public UserPrincipal getUserPrincipal() {
		return userPrincipal;
	}

	/**
	 * Set the UserPrincipal Object.
	 * 
	 * @param userPrincipal
	 */
	void setUserPrincipal(UserPrincipal userPrincipal) {
		this.userPrincipal = userPrincipal;
	}
}