/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import java.util.List;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.stereotype.Component;

import gov.va.med.ccht.persistent.SecurityDAO;

/**
 * AuthenticationManager implementation, extends from Acegi's implementation
 * ProviderManager. Override doAuthentication to add custom behaviour required.
 * 
 * @see <code>net.sf.acegisecurity.providers.ProviderManager</code>
 * 
 * @author DNS
 * @date May 2, 2005 6:04:41 PM
 */
public class AuthenticationManagerImpl extends ProviderManager {
	
	@Autowired
	private SecurityDAO securityDao;
	
	public AuthenticationManagerImpl(List<AuthenticationProvider> providers) {
		super(providers);
	}
	
	@Override
	public void afterPropertiesSet() throws Exception {
		
		super.afterPropertiesSet();
		
		Validate.notNull(securityDao, "securityDao cannot be null");
		
		@SuppressWarnings("rawtypes")
		UserDetailsByNameServiceWrapper userDetailsServiceWrapper = new UserDetailsByNameServiceWrapper(securityDao);
		
		PreAuthenticatedAuthenticationProvider preAuthenticationProvider = new PreAuthenticatedAuthenticationProvider();
		preAuthenticationProvider.setPreAuthenticatedUserDetailsService(userDetailsServiceWrapper);
		
		AnonymousAuthenticationProvider anonymousAuthenticationProvider = new AnonymousAuthenticationProvider("cchtAnonAuthKey");
		
		this.getProviders().add(preAuthenticationProvider);
		this.getProviders().add(anonymousAuthenticationProvider);
		
	}
	
	/*
	 * Checks for loggedIn flag before delegating the authentication request to
	 * the super class. If the user is already logged in, it returns the same
	 * Authentication Object.
	 * 
	 * @see
	 * net.sf.acegisecurity.AbstractAuthenticationManager#doAuthentication(net
	 * .sf.acegisecurity.Authentication)
	 */
	public Authentication doAuthentication(Authentication auth) throws AuthenticationException {
		
		if (auth != null && auth instanceof AuthenticationObject) {
			AuthenticationObject authToken = (AuthenticationObject) auth;
			if (authToken.isLoggedIn()) {
				return auth;
			}
		}
		return super.authenticate(auth);
	}
}