/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.scheduling;

import gov.va.med.fw.service.support.AbstractSpawnedThreadTask;

/**
 * Decoration for a ScheduledProcess such that it can be invoked in a separate
 * Thread for concurrency needs.
 * 
 * Created Apr 28, 2006 12:28:40 PM
 * 
 * @author DNS   DNS
 */
public class SpawnedScheduledProcess extends AbstractSpawnedThreadTask {
	private ScheduledProcess process;

	private ScheduledProcessInvocationContext context;

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.service.support.SpawnedThreadTask#execute()
	 */
	public void executeTask() throws Throwable {
		process.invoke(context);
	}

	/**
	 * @return Returns the process.
	 */
	public ScheduledProcess getProcess() {
		return process;
	}

	/**
	 * @param process
	 *            The process to set.
	 */
	public void setProcess(ScheduledProcess process) {
		this.process = process;
	}

	/**
	 * @return Returns the context.
	 */
	public ScheduledProcessInvocationContext getContext() {
		return context;
	}

	/**
	 * @param context
	 *            The context to set.
	 */
	public void setContext(ScheduledProcessInvocationContext context) {
		this.context = context;
	}
}
