/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.scheduling;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.quartz.Scheduler;

/**
 * Contains context information about the ScheduledProcess that is being
 * invoked.
 * 
 * Created Feb 23, 2006 2:42:30 PM
 * 
 * @author DNS   DNS
 */
public class ScheduledProcessInvocationContext implements Serializable {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7486468289259248552L;

	public static final String INVOCATION_ARGUMENTS = "methodArguments";
	public static final String EXECUTION_CONTEXT = "executionContext";
	static final String DEFAULT_EXECUTION_CONTEXT = "AUTO_PER_SCHEDULE";

	private String jobName;
	private String jobGroup = Scheduler.DEFAULT_GROUP;
	private Object invocationArguments;
	/**
	 * Typically this is information about the user/service that invoked this
	 * scheduled process
	 */
	private String executionContext = DEFAULT_EXECUTION_CONTEXT;

	/* these are used to actually execute job */
	private String jobDetailBeanName;
	private String serviceName;
	private String methodName;

	public String toString() {
		ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE);

		builder.append("jobName", jobName);
		builder.append("jobGroup", jobGroup);
		builder.append("invocationArguments", invocationArguments);
		builder.append("executionContext", executionContext);
		builder.append("jobDetailBeanName", jobDetailBeanName);
		builder.append("serviceName", serviceName);
		builder.append("methodName", methodName);

		return builder.toString();
	}

	/**
	 * @return Returns the invocationArguments.
	 */
	public Object getInvocationArguments() {
		return invocationArguments;
	}

	/**
	 * @param invocationArguments
	 *            The invocationArguments to set.
	 */
	public void setInvocationArguments(Object invocationArguments) {
		this.invocationArguments = invocationArguments;
	}

	/**
	 * @return Returns the jobGroup.
	 */
	public String getJobGroup() {
		return jobGroup;
	}

	/**
	 * @param jobGroup
	 *            The jobGroup to set.
	 */
	public void setJobGroup(String jobGroup) {
		this.jobGroup = jobGroup;
	}

	/**
	 * @return Returns the jobName.
	 */
	public String getJobName() {
		return jobName;
	}

	/**
	 * @param jobName
	 *            The jobName to set.
	 */
	public void setJobName(String jobName) {
		this.jobName = jobName;
	}

	/**
	 * @return Returns the executionContext.
	 */
	public String getExecutionContext() {
		return executionContext;
	}

	/**
	 * @param executionContext
	 *            The executionContext to set.
	 */
	public void setExecutionContext(String executionContext) {
		this.executionContext = executionContext;
	}

	/**
	 * @return Returns the jobDetailBeanName.
	 */
	public String getJobDetailBeanName() {
		return jobDetailBeanName;
	}

	/**
	 * @param jobDetailBeanName
	 *            The jobDetailBeanName to set.
	 */
	public void setJobDetailBeanName(String jobDetailName) {
		this.jobDetailBeanName = jobDetailName;
	}

	/**
	 * @return Returns the serviceName.
	 */
	public String getServiceName() {
		return serviceName;
	}

	/**
	 * @param serviceName
	 *            The serviceName to set.
	 */
	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	/**
	 * @return Returns the methodName.
	 */
	public String getMethodName() {
		return methodName;
	}

	/**
	 * @param methodName
	 *            The methodName to set.
	 */
	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}
}
