/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.rule;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

import gov.va.med.fw.model.AbstractEntity;

/**
 * 
 * Encapsulates how 2 business entities in the application are determined to be
 * equal using business rules.
 * 
 * @author DNS
 * 
 */
public interface MatchRuleService extends Serializable {
	/**
	 * Compares 2 entities for equality. The comparison is based on significant
	 * business attributes in the derived entity classes.
	 * 
	 * @param source
	 *            A source to compare
	 * @param target
	 *            A target to compare
	 * @return True if equal False otherwise
	 */
	public <T extends AbstractEntity> boolean match(T source, T target);

	/**
	 * Finds a matching element in a collection to return.
	 * 
	 * @param source
	 *            A source to look for a match
	 * @param target
	 *            A collection to look for a match
	 * @return AbstractEntity a match
	 */
	public <T extends AbstractEntity> T findMatchingElement(T source, Collection<T> target);

	/**
	 * Finds matching elements in the collection and returns a List with Match
	 * objects which links the source and target objects
	 * 
	 * @param source
	 * @param target
	 * @return
	 */
	public <T extends AbstractEntity> List<Match<T>> match(Collection<T> source,
			Collection<T> target);
}
