package gov.va.med.fw.persistent.hibernate;

import java.util.HashMap;
import java.util.Map;

/**
 * Simple class containing both a query (intended to contain named parameters)
 * and a mapping of parameters to their respective values which will be used in
 * the query.
 * 
 * @author DNS
 * 
 */
public class QueryAndParams {

	// --------------------------- Fields

	private StringBuilder query = new StringBuilder();
	private Map<String, Object> params = new HashMap<String, Object>();

	// --------------------------- Constructors

	public QueryAndParams() {
	}

	public QueryAndParams(String query) {
		this.query.append(query);
	}

	public QueryAndParams(String query, Map<String, Object> params) {
		this(query);
		this.params = params;
	}

	// --------------------------- Business Methods

	public QueryAndParams addParam(String s, Object o) {
		params.put(s, o);
		return this;
	}

	public QueryAndParams addParams(Map<String, Object> newParams) {
		params.putAll(newParams);
		return this;
	}

	public QueryAndParams append(String s) {
		query.append(s);
		return this;
	}

	// --------------------------- Accessor Methods

	public String getQuery() {
		return query.toString();
	}

	public Map<String, Object> getParams() {
		return params;
	}

}
