package gov.va.med.fw.model.lookup;

// Java Classes

// Library Classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework Classes

/**
 * An abstract class that is used as a base class for all lookup entities with a
 * unique name
 * 
 * Project: Framework</br> Created on: 12:51:08 PM </br>
 * 
 * @author DNS
 */
public abstract class AbstractNamedLookup extends AbstractLookup implements NamedLookup {
	private static final long serialVersionUID = 4545725928179823594L;

	/**
	 * The unique business name for this object.
	 * 
	 * @hibernate.property not-null="true" insert="false" update="false"
	 *                     column="NAME" length="80" unique="true"
	 */
	private String name;

	/**
	 * Default constructor.
	 */
	public AbstractNamedLookup() {
		super();
	}

	/**
	 * Returns the unique business name for this object.
	 * 
	 * @return The unique business name for this object.
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * @see gov.va.med.fw.model.lookup.Lookup#getDescription()
	 */
	// public String getDescription() {
	// // If a description doesn't exist, just return the name if one is present
	// if ((super.getDescription() == null) && getName() != null) {
	// return getName();
	// }
	// else {
	// return super.getDescription();
	// }
	// }
	/**
	 * @see gov.va.med.fw.model.lookup.AbstractLookup#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();
		if (this.name != null) {
			this.setName(null);
		}
	}

	/**
	 * @see gov.va.med.fw.model.lookup.AbstractLookup#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("name", this.name);
	}

	/**
	 * Sets the unique business name for this object.
	 * 
	 * @param name
	 *            The unique business name for this object.
	 */
	public void setName(String name) {
		this.name = name;
	}
}