/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model.lookup;

import org.apache.commons.lang.enums.Enum;

/**
 * Super class for lookup constants. Subclasses will define constants that
 * subclass from this.
 * 
 * Created Aug 8, 2005 1:22:10 PM
 * 
 * @author DNS
 */
public class AbstractCode extends Enum {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 1982034128135570724L;

	private String alias = null;

	protected AbstractCode(String code) {
		this(code, null);
	}

	protected AbstractCode(String code, String alias) {
		super(code);
		this.alias = alias;
	}

	protected static AbstractCode getCode(Class clazz, String code) {
		AbstractCode obj = (AbstractCode) getEnum(clazz, code);
		if (obj == null)
			throw new IllegalArgumentException("Unknown code: " + code + " for class: "
					+ clazz.getName());
		return obj;
	}

	public String getCode() {
		return getName();
	}

	public String getAlias() {
		return this.alias;
	}

	public String toString() {
		return "Typed Code value [" + getName() + "]";
	}
}
