/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.model.lookup;

import javax.xml.bind.annotation.XmlTransient;

/**
 * 
 * CISS ohrs_web May 12, 2009
 * 
 * @author DNS
 * 
 *         This class represents a basic lookup that includes an active flag and
 *         a sort column.
 * 
 *         Created because AbstractActiveLookup and AbstractNamedActiveLookup
 *         are extended by objects mapped to tables without the sort_order
 *         column so that field was mapped as transient. Some of those object
 *         are STD tables so we can not add the sort_order column to them.
 */
public abstract class AbstractActiveSortedLookup extends AbstractLookup {
	private static final long serialVersionUID = 1898424560357491234L;
	
	@XmlTransient
	private boolean active = true;
	
	@XmlTransient
	private Integer sortOrder = null;

	/**
	 * Default constructor.
	 */
	public AbstractActiveSortedLookup() {
		super();
	}

	/**
	 * @return the active
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * @param active
	 *            the active to set
	 */
	public void setActive(boolean active) {
		this.active = active;
	}

	/**
	 * Returns a value that describes the relative position of the object when
	 * in a sorted collection.
	 * 
	 * @return A value that describes the relative position of the object when
	 *         in a sorted collection.
	 */
	public Integer getSortOrder() {
		return this.sortOrder;
	}

	/**
	 * Sets a value that describes the relative position of the object when in a
	 * sorted collection.
	 * 
	 * @param sortOrder
	 *            A value that describes the relative position of the object
	 *            when in a sorted collection.
	 */
	public void setSortOrder(Integer sortOrder) {
		this.sortOrder = sortOrder;
	}
}