/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model.batchprocess;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import gov.va.med.ccht.model.CCHTAuditFields;
import gov.va.med.ccht.ui.model.BatchProcessDetailForm;
import gov.va.med.fw.model.lookup.SimpleLookupUtils;

/**
 * Initial javadoc for class JobResult. TODO - Add content here
 * 
 * Created Sep 21, 2006 3:49:29 PM
 * 
 * @author DNS   DNS
 */
@Entity
@Table(schema="ht", name="JOB_RESULT")
public class JobResult extends CCHTAuditFields{
	
	private long id;
	private String name;
	private String group; 
	private Date startDate;
	private Date endDate;
	private String context;
	private String status;
	private String statistics;
	private String jobStatus;

	@Id 
	@GeneratedValue(strategy = javax.persistence.GenerationType.IDENTITY)
	@Column(name = "JOB_RESULT_ID")
	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	@Column(name = "JOB_NAME")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "JOB_GROUP_NAME")
	public String getGroup() {
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}

	@Column(name = "JOB_CONTEXT")
	public String getContext() {
		return context;
	}

	public void setContext(String context) {
		this.context = context;
	}

	@Column(name = "JOB_STATISTICS")
	public String getStatistics() {
		return statistics;
	}

	public void setStatistics(String statistics) {
		this.statistics = statistics;
	}

	@Transient
	public JobStatus getStatus() {
		return (JobStatus) SimpleLookupUtils.getByCode(JobStatus.class, status);
	}

	public void setStatus(JobStatus status) {
		this.status = status.getCode();
	}
	
    @Transient
    public String getFormattedStartDate() {
        return BatchProcessDetailForm.formatter.format(getStartDate());
    }

    @Transient
    public String getFormattedEndDate() {
        return BatchProcessDetailForm.formatter.format(getEndDate());
    }

	@Column(name = "JOB_END_DATE")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	@Column(name = "JOB_START_DATE")
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	@Column(name = "JOB_STATUS_CODE")
	public String getJobStatus() {
		return jobStatus;
	}

	public void setJobStatus(String jobStatus) {
		this.jobStatus = jobStatus;
	}

}
