/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model.batchprocess;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import edu.emory.mathcs.backport.java.util.Arrays;
import gov.va.med.fw.security.Permission;

/**
 * Initial javadoc for class JobConfig.
 * 
 * Created Sep 21, 2006 3:47:47 PM
 * 
 * @author DNS   DNS
 */
@Entity
@Table(schema="ht", name="JOB_CONFIG")
public class JobConfig {

	private long id;
	private String name;
	private String group;
	private String emailDistributionList;
	private Date createdOn;
	private Date modifiedOn;
	private String createdBy;
	private String modifiedBy;
	private Set<BatchJobPermission> internalPermisions = null;
	
	private String schedule;
	private String scheduleText;
	private String scheduleDescription;
	
	@Id 
	@GeneratedValue(strategy = javax.persistence.GenerationType.IDENTITY)
	@Column(name = "JOB_CONFIG_ID")
	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	@Column(name = "JOB_NAME")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "JOB_GROUP_NAME")
	public String getGroup() {
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}
	
	@Transient
	public List<String> getEmailsAsList() {
		return new ArrayList<String>(Arrays.asList(emailDistributionList.split(",")));
	}

	@Column(name = "EMAIL_DISTRIBUTION_LIST")
	public String getEmailDistributionList() {
		return emailDistributionList;
	}

	public void setEmailDistributionList(String emailDistributionList) {
		this.emailDistributionList = emailDistributionList;
	}

	@Column(name = "RECORD_CREATED_DATE")
	public Date getCreatedOn() {
		return createdOn;
	}

	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	@Column(name = "RECORD_MODIFIED_DATE")
	public Date getModifiedOn() {
		return modifiedOn;
	}

	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	@Column(name = "RECORD_CREATED_BY")
	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Column(name = "RECORD_MODIFIED_BY")
	public String getModifiedBy() {
		return modifiedBy;
	}

	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	@Transient
	public Set<Permission> getPermissions() {
		Set<Permission> permisions = new HashSet<Permission>();
		getInternalPermisions().forEach(bjp -> {
			permisions.add(bjp.getPermission());
		});
		return permisions;
	}

	@Transient
	private Set<BatchJobPermission> getInternalPermisions() {
		if (internalPermisions == null) {
			internalPermisions = new HashSet<BatchJobPermission>();
		}
		return internalPermisions;
	}

	@Transient
	public String getJobSchedule() {
		return schedule;
	}

	public void setJobSchedule(String schedule) {
		this.schedule = schedule;
	}

	@Transient
	public String getJobScheduleText() {
		return scheduleText;
	}

	public void setJobScheduleText(String scheduleText) {
		this.scheduleText = scheduleText;
	}

	@Transient
	public String getJobScheduleDescription() {
		return scheduleDescription;
	}

	public void setJobScheduleDescription(String scheduleDescription) {
		this.scheduleDescription = scheduleDescription;
	}
	
	
	
}
