/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model.batchprocess;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Initial javadoc for class AbstractJob.
 * 
 * Created Sep 21, 2006 3:48:11 PM
 * 
 * @author DNS   DNS
 */
public class AbstractJob<T> extends AbstractKeyedEntity<T> {
	/**
	 * serialVersionUID long
	 */
	private static final long serialVersionUID = 5069566142788813099L;
	private String jobName;
	private String jobGroup;
	private String jobSchedule;
	private String jobScheduleDescription;
	private String jobScheduleText;
	private String emailDistributionList;
	
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("jobName", this.jobName);
		builder.append("jobGroup", this.jobGroup);
	}

	public String getJobName() {
		return jobName;
	}

	public void setJobName(String jobName) {
		this.jobName = jobName;
	}

	public String getJobGroup() {
		return jobGroup;
	}

	public void setJobGroup(String jobGroup) {
		this.jobGroup = jobGroup;
	}

	public String getJobSchedule() {
		return jobSchedule;
	}

	public void setJobSchedule(String jobSchedule) {
		this.jobSchedule = jobSchedule;
	}

	public String getJobScheduleDescription() {
		return jobScheduleDescription;
	}

	public void setJobScheduleDescription(String jobScheduleDescription) {
		this.jobScheduleDescription = jobScheduleDescription;
	}

	public String getJobScheduleText() {
		return jobScheduleText;
	}

	public void setJobScheduleText(String jobScheduleText) {
		this.jobScheduleText = jobScheduleText;
	}

	public String getEmailDistributionList() {
		return emailDistributionList;
	}

	public void setEmailDistributionList(String emailDistributionList) {
		this.emailDistributionList = emailDistributionList;
	}
	public List<String> getEmailsAsList() {
		List<String> emails = new ArrayList<String>();
		if (StringUtils.isNotBlank(getEmailDistributionList())) {
			String[] adds = getEmailDistributionList().split(",");
			for (int i = 0; i < adds.length; i++)
				emails.add(adds[i].trim());
		}
		return emails;
	}	
}
