/********************************************************************
 * Copyriight 2009 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import gov.va.med.fw.ui.model.TermType;
import gov.va.med.fw.util.StringUtils;

/**
 * Created March 10 2009
 * 
 * @author Muddaiah Ranga
 */
public class ProtectedRegionVersionKey implements Serializable {

	private static final long serialVersionUID = -4435111942661781465L;

	private Map<String, Integer> regionVersionMap = new HashMap<String, Integer>();

	public ProtectedRegionVersionKey() {
	}

	public ProtectedRegionVersionKey(Map<String, Integer> regionVersionMap) {
		this.regionVersionMap = regionVersionMap;
	}

	public void addRegionVersion(String region, Integer version) {
		if (StringUtils.isNotEmpty(region) && version != null) {
			regionVersionMap.put(region, version);
		}
	}

	public void addRegionVersion(Collection<TermType> regionVersions) {
		if (regionVersions != null) {
			for (TermType regionVersion : regionVersions) {
				if (regionVersion != null && StringUtils.isNotEmpty(regionVersion.getLabel())
						&& StringUtils.isNotEmpty(regionVersion.getValue())) {
					regionVersionMap.put(regionVersion.getLabel(), Integer.valueOf(regionVersion
							.getValue()));
				}
			}
		}
	}

	public Set<String> getRegions() {
		return regionVersionMap != null ? regionVersionMap.keySet() : null;
	}

	public Integer getVersionedForRegion(String region) {
		return (region != null && regionVersionMap != null) ? regionVersionMap.get(region) : null;
	}

	public Set<TermType> getRegionVersionList() {
		Set<TermType> set = null;
		if (regionVersionMap != null && regionVersionMap.size() > 0) {
			set = new HashSet<TermType>();
			for (String region : regionVersionMap.keySet()) {
				set.add(new TermType(region, regionVersionMap.get(region).toString()));
			}
		}
		return set;
	}

}
