/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.model;

// Java classes
import java.io.Serializable;

import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * Base implementation of EntityKey
 * 
 * Created Jul 19, 2005 10:17:32 AM
 * 
 * @author DNS   DNS
 */
public class BaseEntityKey<T> extends AbstractEntity implements VersionedEntityKey<T> {

	/**
	 * A serialize version id
	 */
	private static final long serialVersionUID = -8061022674572324212L;

	private static String SUMMARY_SEPARATOR = "-";

	/** Wrapped identifier */
	private Serializable keyValue;

	/** Class that the identifier is for */
	private Class<T> entityClass;

	/** Optional version number to verify against */
	private Integer version;

	public BaseEntityKey(Serializable keyValue, Class<T> entityClass) {
		Validate.notNull(keyValue, "Null keyValue");
		Validate.notNull(entityClass, "Null entityClass");

		this.keyValue = keyValue;
		this.entityClass = entityClass;
	}

	public BaseEntityKey(Serializable keyValue, Integer version, Class<T> entityClass) {
		this(keyValue, entityClass);

		this.version = version;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.EntityKey#getKeyValue()
	 */
	public Serializable getKeyValue() {
		return keyValue;
	}

	protected void buildToString(ToStringBuilder builder) {
		builder.append("keyValue", keyValue);
		builder.append("entityClass", entityClass);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.EntityKey#getEntityClass()
	 */
	public Class<T> getEntityClass() {
		return entityClass;
	}

	public String getKeyValueAsString() {
		// No need to check for null since a key value must not be null
		return getKeyValue().toString();
	}

	public String getSummary() {
		return getEntityClass() != null ? getKeyValue() + SUMMARY_SEPARATOR
				+ ClassUtils.getShortClassName(getEntityClass()) : getKeyValueAsString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.VersionedEntityKey#getVersion()
	 */
	public Integer getVersion() {
		return version;
	}

	/** Provide capability to disable the version check. */
	public void disableVersionCheck() {
		version = null;
	}
}
