/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZSP segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZSP extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 1547478163445200140L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZSP() {
		super();
		setName(SegmentConstants.ZSP);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZSP(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZSP(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZSP(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZSP(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * Sequential number
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * Sequential number
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * SERVICE CONNECTED? (.301)
	 * 
	 * @param input
	 *            A value of ServiceConnected
	 */
	public void setServiceConnected(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * SERVICE CONNECTED? (.301)
	 * 
	 * @return String A value of ServiceConnected
	 */
	public String getServiceConnected() {
		return getElement(1);
	}

	/**
	 * 
	 * SERVICE CONNECTED PERCENTAGE (.302)
	 * 
	 * @param input
	 *            A value of ServiceConnectedPercentage
	 */
	public void setServiceConnectedPercentage(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * SERVICE CONNECTED PERCENTAGE (.302)
	 * 
	 * @return String A value of ServiceConnectedPercentage
	 */
	public String getServiceConnectedPercentage() {
		return getElement(2);
	}

	/**
	 * 
	 * PERIOD OF SERVICE (.323)
	 * 
	 * @param input
	 *            A value of ServicePeriod
	 */
	public void setServicePeriod(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * PERIOD OF SERVICE (.323)
	 * 
	 * @return String A value of ServicePeriod
	 */
	public String getServicePeriod() {
		return getElement(3);
	}

	/**
	 * 
	 * VIETNAM SERVICE INDICATED? (.32101)
	 * 
	 * @param input
	 *            A value of VietnamServiceIndicated
	 */
	public void setVietnamServiceIndicated(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * VIETNAM SERVICE INDICATED? (.32101)
	 * 
	 * @return String A value of VietnamServiceIndicated
	 */
	public String getVietnamServiceIndicated() {
		return getElement(4);
	}

	/**
	 * 
	 * Permanent and Total (.304)
	 * 
	 * @param input
	 *            A value of PermanentAndTotal
	 */
	public void setPermanentAndTotal(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * Permanent and Total (.304)
	 * 
	 * @return String A value of PermanentAndTotal
	 */
	public String getPermanentAndTotal() {
		return getElement(5);
	}

	/**
	 * 
	 * UNEMPLOYABLE (.305)
	 * 
	 * @param input
	 *            A value of Unemployable
	 */
	public void setUnemployable(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * UNEMPLOYABLE (.305)
	 * 
	 * @return String A value of Unemployable
	 */
	public String getUnemployable() {
		return getElement(6);
	}

	/**
	 * 
	 * SC AWARD DATE (.3012) IMPRECISE
	 * 
	 * @param input
	 *            A value of ServiceConnectedAwardDate
	 */
	public void setServiceConnectedAwardDate(String input) {
		setElement(input, 7);
	}

	/**
	 * 
	 * SC AWARD DATE (.3012) IMPRECISE
	 * 
	 * @return String A value of ServiceConnectedAwardDate
	 */
	public String getServiceConnectedAwardDate() {
		return getElement(7);
	}

	/**
	 * 
	 * SERVICE VERIFICATION DATE (.322)
	 * 
	 * @param input
	 *            A value of ServiceVerificationDate
	 */
	public void setServiceVerificationDate(String input) {
		setElement(input, 8);
	}

	/**
	 * 
	 * SERVICE VERIFICATION DATE (.322)
	 * 
	 * @return String A value of ServiceVerificationDate
	 */
	public String getServiceVerificationDate() {
		return getElement(8);
	}

	/**
	 * 
	 * HINQ
	 * 
	 * @param input
	 *            A value of PermanentAndTotalEffectiveDate
	 */
	public void setPermanentAndTotalEffectiveDate(String input) {
		setElement(input, 9);
	}

	/**
	 * 
	 * HINQ
	 * 
	 * @return String A value of PermanentAndTotalEffectiveDate
	 */
	public String getPermanentAndTotalEffectiveDate() {
		return getElement(9);
	}

	/**
	 * 
	 * COMBINED SC PERCENT EFFECTIVE DATE - FORMAT MMDDYYYY
	 * 
	 * @param input
	 *            A value of CombinedSCPercentEffectiveDate
	 */
	public void setCombinedSCPercentEffectiveDate(String input) {
		setElement(input, 10);
	}

	/**
	 * 
	 * COMBINED SC PERCENT EFFECTIVE DATE - FORMAT MMDDYYYY
	 * 
	 * @return String A value of CombinedSCPercentEffectiveDate
	 */
	public String getCombinedSCPercentEffectiveDate() {
		return getElement(10);
	}
}