/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZIO segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZIO extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4643318672092656349L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZIO() {
		super();
		setName(SegmentConstants.ZIO);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIO(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIO(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIO(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIO(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * Sequential Number
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * Sequential Number
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * Computed
	 * 
	 * @param input
	 *            A value of InpatientDaysSinceLastMeansTest
	 */
	public void setInpatientDaysSinceLastMeansTest(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * Computed
	 * 
	 * @return String A value of InpatientDaysSinceLastMeansTest
	 */
	public String getInpatientDaysSinceLastMeansTest() {
		return getElement(1);
	}

	/**
	 * 
	 * Computed
	 * 
	 * @param input
	 *            A value of OutpatientDaysSinceLastMeansTest
	 */
	public void setOutpatientDaysSinceLastMeansTest(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * Computed
	 * 
	 * @return String A value of OutpatientDaysSinceLastMeansTest
	 */
	public String getOutpatientDaysSinceLastMeansTest() {
		return getElement(2);
	}

	/**
	 * 
	 * Computed (Last OPT or Inpatient stay) (Precise)
	 * 
	 * @param input
	 *            A value of LastVisitDate
	 */
	public void setLastVisitDate(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * Computed (Last OPT or Inpatient stay) (Precise)
	 * 
	 * @return String A value of LastVisitDate
	 */
	public String getLastVisitDate() {
		return getElement(3);
	}

	/**
	 * 
	 * APPOINTMENT REQUEST ON 1010EZ.
	 * 
	 * @param input
	 *            A value of Appointment Request On 1010EZ
	 */
	public void setAppointmentRequestOn1010EZ(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * APPOINTMENT REQUEST ON 1010EZ.
	 * 
	 * @return String A value of APPOINTMENT REQUEST ON 1010EZ.
	 */
	public String getAppointmentRequestOn1010EZ() {
		return getElement(4);
	}

	/**
	 * 
	 * APPOINTMENT REQUEST DATE
	 * 
	 * @param input
	 *            A value of Appointment Request On 1010EZ
	 */
	public void setAppointmentRequestDate(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * APPOINTMENT REQUEST DATE
	 * 
	 * @return String A value of APPOINTMENT REQUEST Date
	 */
	public String getAppointmentRequestDate() {
		return getElement(5);
	}
}