/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZEL segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZEL extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 982444153945742478L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZEL() {
		super();
		setName(SegmentConstants.ZEL);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEL(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEL(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEL(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEL(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * SEQUENTIAL NUMBER (1 is always primary eligibility)
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * SEQUENTIAL NUMBER (1 is always primary eligibility)
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * ELIGIBILITY CODE
	 * 
	 * @param input
	 *            A value of EligibilityCode
	 */
	public void setEligibilityCode(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * ELIGIBILITY CODE
	 * 
	 * @return String A value of EligibilityCode
	 */
	public String getEligibilityCode() {
		return getElement(1);
	}

	/**
	 * 
	 * LONG ID (multiple 361 field .01)
	 * 
	 * @param input
	 *            A value of LongID
	 */
	public void setLongID(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * LONG ID (multiple 361 field .01)
	 * 
	 * @return String A value of LongID
	 */
	public String getLongID() {
		return getElement(2);
	}

	/**
	 * 
	 * SHORT ID (multiple 361 field .04)
	 * 
	 * @param input
	 *            A value of ShortID
	 */
	public void setShortID(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * SHORT ID (multiple 361 field .04)
	 * 
	 * @return String A value of ShortID
	 */
	public String getShortID() {
		return getElement(3);
	}

	/**
	 * 
	 * DISABILITY RETIREMENT FROM MIL. (.362)
	 * 
	 * @param input
	 *            A value of DisabilityRetirementFromMilitary
	 */
	public void setDisabilityRetirementFromMilitary(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * DISABILITY RETIREMENT FROM MIL. (.362)
	 * 
	 * @return String A value of DisabilityRetirementFromMilitary
	 */
	public String getDisabilityRetirementFromMilitary() {
		return getElement(4);
	}

	/**
	 * 
	 * CLAIM FOLDER NUMBER (.313) (Can receive a SSN) (VISTA Messaging HL7)
	 * 
	 * @param input
	 *            A value of ClaimFolderNumber
	 */
	public void setClaimFolderNumber(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * CLAIM FOLDER NUMBER (.313) (Can receive a SSN) (VISTA Messaging HL7)
	 * 
	 * @return String A value of ClaimFolderNumber
	 */
	public String getClaimFolderNumber() {
		return getElement(5);
	}

	/**
	 * 
	 * CLAIM FOLDER LOCATION (.312)
	 * 
	 * @param input
	 *            A value of ClaimFolderLocation
	 */
	public void setClaimFolderLocation(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * CLAIM FOLDER LOCATION (.312)
	 * 
	 * @return String A value of ClaimFolderLocation
	 */
	public String getClaimFolderLocation() {
		return getElement(6);
	}

	/**
	 * 
	 * VETERAN? (1901)
	 * 
	 * @param input
	 *            A value of Veteran
	 */
	public void setVeteran(String input) {
		setElement(input, 7);
	}

	/**
	 * 
	 * VETERAN? (1901)
	 * 
	 * @return String A value of Veteran
	 */
	public String getVeteran() {
		return getElement(7);
	}

	/**
	 * 
	 * TYPE OF PATIENT (391)
	 * 
	 * @param input
	 *            A value of PatientType
	 */
	public void setPatientType(String input) {
		setElement(input, 8);
	}

	/**
	 * 
	 * TYPE OF PATIENT (391)
	 * 
	 * @return String A value of PatientType
	 */
	public String getPatientType() {
		return getElement(8);
	}

	/**
	 * 
	 * ELIGIBILITY STATUS (.3611)
	 * 
	 * @param input
	 *            A value of EligibilityStatus
	 */
	public void setEligibilityStatus(String input) {
		setElement(input, 9);
	}

	/**
	 * 
	 * ELIGIBILITY STATUS (.3611)
	 * 
	 * @return String A value of EligibilityStatus
	 */
	public String getEligibilityStatus() {
		return getElement(9);
	}

	/**
	 * 
	 * ELIGIBILITY STATUS DATE (.3612) (Imprecise)
	 * 
	 * @param input
	 *            A value of EligibilityStatusDate
	 */
	public void setEligibilityStatusDate(String input) {
		setElement(input, 10);
	}

	/**
	 * 
	 * ELIGIBILITY STATUS DATE (.3612) (Imprecise)
	 * 
	 * @return String A value of EligibilityStatusDate
	 */
	public String getEligibilityStatusDate() {
		return getElement(10);
	}

	/**
	 * 
	 * ELIGIBILITY INTERIM RESPONSE (.3614)
	 * 
	 * @param input
	 *            A value of EligibilityInterimResponse
	 */
	public void setEligibilityInterimResponse(String input) {
		setElement(input, 11);
	}

	/**
	 * 
	 * ELIGIBILITY INTERIM RESPONSE (.3614)
	 * 
	 * @return String A value of EligibilityInterimResponse
	 */
	public String getEligibilityInterimResponse() {
		return getElement(11);
	}

	/**
	 * 
	 * ELIGIBILITY VERIFICATION METHOD (.3615)
	 * 
	 * @param input
	 *            A value of EligibilityVerificationMethod
	 */
	public void setEligibilityVerificationMethod(String input) {
		setElement(input, 12);
	}

	/**
	 * 
	 * ELIGIBILITY VERIFICATION METHOD (.3615)
	 * 
	 * @return String A value of EligibilityVerificationMethod
	 */
	public String getEligibilityVerificationMethod() {
		return getElement(12);
	}

	/**
	 * 
	 * RECEIVING A and A BENEFITS? (.36205)
	 * 
	 * @param input
	 *            A value of ReceivingAABenefits
	 */
	public void setReceivingAABenefits(String input) {
		setElement(input, 13);
	}

	/**
	 * 
	 * RECEIVING A and A BENEFITS? (.36205)
	 * 
	 * @return String A value of ReceivingAABenefits
	 */
	public String getReceivingAABenefits() {
		return getElement(13);
	}

	/**
	 * 
	 * RECEIVING HOUSEBOUND BENEFITS? (.36215)
	 * 
	 * @param input
	 *            A value of ReceivingHouseboundBenefits
	 */
	public void setReceivingHouseboundBenefits(String input) {
		setElement(input, 14);
	}

	/**
	 * 
	 * RECEIVING HOUSEBOUND BENEFITS? (.36215)
	 * 
	 * @return String A value of ReceivingHouseboundBenefits
	 */
	public String getReceivingHouseboundBenefits() {
		return getElement(14);
	}

	/**
	 * 
	 * RECEIVING A VA PENSION? (.36235)
	 * 
	 * @param input
	 *            A value of ReceivingVaPension
	 */
	public void setReceivingVaPension(String input) {
		setElement(input, 15);
	}

	/**
	 * 
	 * RECEIVING A VA PENSION? (.36235)
	 * 
	 * @return String A value of ReceivingVaPension
	 */
	public String getReceivingVaPension() {
		return getElement(15);
	}

	/**
	 * 
	 * RECEIVING VA DISABILITY? (.3025)
	 * 
	 * @param input
	 *            A value of ReceivingVaDisability
	 */
	public void setReceivingVaDisability(String input) {
		setElement(input, 16);
	}

	/**
	 * 
	 * RECEIVING VA DISABILITY? (.3025)
	 * 
	 * @return String A value of ReceivingVaDisability
	 */
	public String getReceivingVaDisability() {
		return getElement(16);
	}

	/**
	 * 
	 * AGENT ORANGE EXPOS. INDICATED (.32102)
	 * 
	 * @param input
	 *            A value of AgentOrangeExposure
	 */
	public void setAgentOrangeExposure(String input) {
		setElement(input, 17);
	}

	/**
	 * 
	 * AGENT ORANGE EXPOS. INDICATED (.32102)
	 * 
	 * @return String A value of AgentOrangeExposure
	 */
	public String getAgentOrangeExposure() {
		return getElement(17);
	}

	/**
	 * 
	 * RADIATION EXPOSURE INDICATED? (.32103)
	 * 
	 * @param input
	 *            A value of RadiationExposure
	 */
	public void setRadiationExposure(String input) {
		setElement(input, 18);
	}

	/**
	 * 
	 * RADIATION EXPOSURE INDICATED? (.32103)
	 * 
	 * @return String A value of RadiationExposure
	 */
	public String getRadiationExposure() {
		return getElement(18);
	}

	/**
	 * 
	 * ENVIRONMENTAL CONTAMINANTS? (.322013)
	 * 
	 * @param input
	 *            A value of EnvironmentalContaminants
	 */
	public void setEnvironmentalContaminants(String input) {
		setElement(input, 19);
	}

	/**
	 * 
	 * ENVIRONMENTAL CONTAMINANTS? (.322013)
	 * 
	 * @return String A value of EnvironmentalContaminants
	 */
	public String getEnvironmentalContaminants() {
		return getElement(19);
	}

	/**
	 * 
	 * TOTAL ANNUAL VA CHECK AMOUNT (.36295)
	 * 
	 * @param input
	 *            A value of TotalAnnualVaCheckAmount
	 */
	public void setTotalAnnualVaCheckAmount(String input) {
		setElement(input, 20);
	}

	/**
	 * 
	 * TOTAL ANNUAL VA CHECK AMOUNT (.36295)
	 * 
	 * @return String A value of TotalAnnualVaCheckAmount
	 */
	public String getTotalAnnualVaCheckAmount() {
		return getElement(20);
	}

	/**
	 * 
	 * RADIATION EXPOSURE METHOD (.3212) Values: N - NAGASAKI/HIROSHIMA T -
	 * NUCLEAR TESTING B � BOTH (VISTA Messaging HL7)
	 * 
	 * @param input
	 *            A value of RadiationExposureMethod
	 */
	public void setRadiationExposureMethod(String input) {
		setElement(input, 21);
	}

	/**
	 * 
	 * RADIATION EXPOSURE METHOD (.3212) Values: N - NAGASAKI/HIROSHIMA T -
	 * NUCLEAR TESTING B � BOTH (VISTA Messaging HL7)
	 * 
	 * @return String A value of RadiationExposureMethod
	 */
	public String getRadiationExposureMethod() {
		return getElement(21);
	}

	/**
	 * 
	 * CURRENT MST STATUS (File# 29.11/Field# 3) (VISTA Messaging HL7)
	 * 
	 * @param input
	 *            A value of MstStatus
	 */
	public void setMstStatus(String input) {
		setElement(input, 22);
	}

	/**
	 * 
	 * CURRENT MST STATUS (File# 29.11/Field# 3) (VISTA Messaging HL7)
	 * 
	 * @return String A value of MstStatus
	 */
	public String getMstStatus() {
		return getElement(22);
	}

	/**
	 * 
	 * MST STATUS CHANGE DATE (File# 29.11/Field# .01) (Precise)
	 * 
	 * @param input
	 *            A value of MstStatusChangeDate
	 */
	public void setMstStatusChangeDate(String input) {
		setElement(input, 23);
	}

	/**
	 * 
	 * MST STATUS CHANGE DATE (File# 29.11/Field# .01) (Precise)
	 * 
	 * @return String A value of MstStatusChangeDate
	 */
	public String getMstStatusChangeDate() {
		return getElement(23);
	}

	/**
	 * 
	 * SITE DETERMINING MST STATUS (File#29.11/Field# 6) (VISTA Messaging HL7)
	 * 
	 * @param input
	 *            A value of MstStatusDeterminingSite
	 */
	public void setMstStatusDeterminingSite(String input) {
		setElement(input, 24);
	}

	/**
	 * 
	 * SITE DETERMINING MST STATUS (File#29.11/Field# 6) (VISTA Messaging HL7)
	 * 
	 * @return String A value of MstStatusDeterminingSite
	 */
	public String getMstStatusDeterminingSite() {
		return getElement(24);
	}

	/**
	 * 
	 * AGENT ORANGE REGISTRATION DATE (.32107) (Imprecise)
	 * 
	 * @param input
	 *            A value of AgentOrangeRegistrationDate
	 */
	public void setAgentOrangeRegistrationDate(String input) {
		setElement(input, 25);
	}

	/**
	 * 
	 * AGENT ORANGE REGISTRATION DATE (.32107) (Imprecise)
	 * 
	 * @return String A value of AgentOrangeRegistrationDate
	 */
	public String getAgentOrangeRegistrationDate() {
		return getElement(25);
	}

	/**
	 * 
	 * AGENT ORANGE EXAM DATE (.32109) (Imprecise)
	 * 
	 * @param input
	 *            A value of AgentOrangeExamDate
	 */
	public void setAgentOrangeExamDate(String input) {
		setElement(input, 26);
	}

	/**
	 * 
	 * AGENT ORANGE EXAM DATE (.32109) (Imprecise)
	 * 
	 * @return String A value of AgentOrangeExamDate
	 */
	public String getAgentOrangeExamDate() {
		return getElement(26);
	}

	/**
	 * 
	 * AGENT ORANGE REGISTRATION # (.3211)
	 * 
	 * @param input
	 *            A value of AgentOrangeRegistrationNumber
	 */
	public void setAgentOrangeRegistrationNumber(String input) {
		setElement(input, 27);
	}

	/**
	 * 
	 * AGENT ORANGE REGISTRATION # (.3211)
	 * 
	 * @return String A value of AgentOrangeRegistrationNumber
	 */
	public String getAgentOrangeRegistrationNumber() {
		return getElement(27);
	}

	/**
	 * 
	 * AGENT ORANGE EXPOSURE LOCATION (.3213)
	 * 
	 * @param input
	 *            A value of AgentOrangeExposureLocation
	 */
	public void setAgentOrangeExposureLocation(String input) {
		setElement(input, 28);
	}

	/**
	 * 
	 * AGENT ORANGE EXPOSURE LOCATION (.3213)
	 * 
	 * @return String A value of AgentOrangeExposureLocation
	 */
	public String getAgentOrangeExposureLocation() {
		return getElement(28);
	}

	/**
	 * 
	 * RADIATION REGISTRATION DATE (.32111) (Imprecise)
	 * 
	 * @param input
	 *            A value of RadiationRegistrationDate
	 */
	public void setRadiationRegistrationDate(String input) {
		setElement(input, 29);
	}

	/**
	 * 
	 * RADIATION REGISTRATION DATE (.32111) (Imprecise)
	 * 
	 * @return String A value of RadiationRegistrationDate
	 */
	public String getRadiationRegistrationDate() {
		return getElement(29);
	}

	/**
	 * 
	 * ENVIR. CONT. EXAM DATE (.322015) (Imprecise)
	 * 
	 * @param input
	 *            A value of EnvironmentalContaminantsExamDate
	 */
	public void setEnvironmentalContaminantsExamDate(String input) {
		setElement(input, 30);
	}

	/**
	 * 
	 * ENVIR. CONT. EXAM DATE (.322015) (Imprecise)
	 * 
	 * @return String A value of EnvironmentalContaminantsExamDate
	 */
	public String getEnvironmentalContaminantsExamDate() {
		return getElement(30);
	}

	/**
	 * 
	 * ENVIR. CONT. REGISTRATION DATE (.322014) (Imprecise)
	 * 
	 * @param input
	 *            A value of EnvironmentalContaminantsRegistrationDate
	 */
	public void setEnvironmentalContaminantsRegistrationDate(String input) {
		setElement(input, 31);
	}

	/**
	 * 
	 * ENVIR. CONT. REGISTRATION DATE (.322014) (Imprecise)
	 * 
	 * @return String A value of EnvironmentalContaminantsRegistrationDate
	 */
	public String getEnvironmentalContaminantsRegistrationDate() {
		return getElement(31);
	}

	/**
	 * 
	 * MONETARY BEN. VERIFY DATE (.306) (Imprecise)
	 * 
	 * @param input
	 *            A value of MonetaryBenefitsDate
	 */
	public void setMonetaryBenefitsDate(String input) {
		setElement(input, 32);
	}

	/**
	 * 
	 * MONETARY BEN. VERIFY DATE (.306) (Imprecise)
	 * 
	 * @return String A value of MonetaryBenefitsDate
	 */
	public String getMonetaryBenefitsDate() {
		return getElement(32);
	}

	/**
	 * 
	 * USER ENROLLEE VALID THROUGH (.3617) (Imprecise)
	 * 
	 * @param input
	 *            A value of UserEnrolleeValidThrough
	 */
	public void setUserEnrolleeValidThrough(String input) {
		setElement(input, 33);
	}

	/**
	 * 
	 * USER ENROLLEE VALID THROUGH (.3617) (Imprecise)
	 * 
	 * @return String A value of UserEnrolleeValidThrough
	 */
	public String getUserEnrolleeValidThrough() {
		return getElement(33);
	}

	/**
	 * 
	 * USER ENROLLEE SITE (.3618)
	 * 
	 * @param input
	 *            A value of UserEnrolleeSite
	 */
	public void setUserEnrolleeSite(String input) {
		setElement(input, 34);
	}

	/**
	 * 
	 * USER ENROLLEE SITE (.3618)
	 * 
	 * @return String A value of UserEnrolleeSite
	 */
	public String getUserEnrolleeSite() {
		return getElement(34);
	}

	/**
	 * 
	 * ELIGIBILITY VERIFICATION SOURCE/SITE
	 * 
	 * @param input
	 *            A value of EligibilityVerificationSource
	 */
	public void setEligibilityVerificationSource(String input) {
		setElement(input, 35);
	}

	/**
	 * 
	 * ELIGIBILITY VERIFICATION SOURCE/SITE
	 * 
	 * @return String A value of EligibilityVerificationSource
	 */
	public String getEligibilityVerificationSource() {
		return getElement(35);
	}

	/**
	 * 
	 * COMBAT SERVICE INDICATED? Field (#.5291) (Computed)
	 * 
	 * @param input
	 *            A value of CombatVeteranEligibilityIndicator
	 */
	public void setCombatVeteranEligibilityIndicator(String input) {
		setElement(input, 36);
	}

	/**
	 * 
	 * COMBAT SERVICE INDICATED? Field (#.5291) (Computed)
	 * 
	 * @return String A value of CombatVeteranEligibilityIndicator
	 */
	public String getCombatVeteranEligibilityIndicator() {
		return getElement(36);
	}

	/**
	 * 
	 * COMBAT VETERAN END DATE Field (#5295) (Precise)
	 * 
	 * @param input
	 *            A value of CombatVeteranEligibilityEndDate
	 */
	public void setCombatVeteranEligibilityEndDate(String input) {
		setElement(input, 37);
	}

	/**
	 * 
	 * COMBAT VETERAN END DATE Field (#5295) (Precise)
	 * 
	 * @return String A value of CombatVeteranEligibilityEndDate
	 */
	public String getCombatVeteranEligibilityEndDate() {
		return getElement(37);
	}

	/**
	 * Discharge Due to Disability. Added in I3. Values Yes, No, Null
	 * 
	 * @return DischargeDueToDisability
	 */
	public void setDischargeDueToDisability(String input) {
		setElement(input, 38);
	}

	/**
	 * Discharge Due to Disability. Added in I3. Values Yes, No, Null
	 * 
	 */
	public String getDischargeDueToDisability() {
		return getElement(38);
	}

	/**
	 * PROJ 112/SHAD INDICATOR. Added in I3. Yes/No values
	 * 
	 */
	public void setShadIndicator(String input) {
		setElement(input, 39);
	}

	/**
	 * PROJ 112/SHAD INDICATOR. Added in I3. Yes/No values
	 * 
	 * @return ShadIndicator
	 */
	public String getShadIndicator() {
		return getElement(39);
	}

}