/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * @author DNS
 * @version 1.0
 */
public class MSH extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 565714924834628595L;

	/**
	 * @throws InvalidSegmentException
	 */
	public MSH() {
		super();
		setName(SegmentConstants.MSH);
	}

	/**
	 * @param data
	 * @throws InvalidSegmentException
	 */
	public MSH(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * @param encodingChars
	 * @param elementDelimiter
	 * @param segmentData
	 * @throws InvalidSegmentException
	 */
	public MSH(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * @param name
	 * @param elements
	 * @throws InvalidSegmentException
	 */
	public MSH(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * @param encodingChars
	 * @param elementDelimiter
	 * @param segmentName
	 * @param segmentElements
	 * @throws InvalidSegmentException
	 */
	public MSH(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	public void setFieldSeparator(String input) {
		setElement(input, 0);
		setElementDelimiter(input);
	}

	public String getFieldSeparator() {
		return getElement(0);
	}

	public void setEncodingCharacters(String input) {
		setElement(input, 1);
	}

	public String getEncodingCharacters() {
		return getElement(1);
	}

	public void setSendingApplication(String input) {
		setElement(input, 2);
	}

	public String getSendingApplication() {
		return getElement(2);
	}

	public void setSendingFacility(String input) {
		setElement(input, 3);
	}

	public String getSendingFacility() {
		return getElement(3);
	}

	public void setReceivingApplication(String input) {
		setElement(input, 4);
	}

	public String getReceivingApplication() {
		return getElement(4);
	}

	public void setReceivingFacility(String input) {
		setElement(input, 5);
	}

	public String getReceivingFacility() {
		return getElement(5);
	}

	public void setCreationDate(String input) {
		setElement(input, 6);
	}

	public String getCreationDate() {
		return getElement(6);
	}

	public void setSecurity(String input) {
		setElement(input, 7);
	}

	public String getSecurity() {
		return getElement(7);
	}

	public void setMessageType(String input) {
		setElement(input, 8);
	}

	public String getMessageType() {
		return getElement(8);
	}

	public void setControlID(String input) {
		setElement(input, 9);
	}

	public String getControlID() {
		return getElement(9);
	}

	public void setProcessingID(String input) {
		setElement(input, 10);
	}

	public String getProcessingID() {
		return getElement(10);
	}

	public void setVersionID(String input) {
		setElement(input, 11);
	}

	public String getVersionID() {
		return getElement(11);
	}

	public void setSequenceNumber(String input) {
		setElement(input, 12);
	}

	public String getSequenceNumber() {
		return getElement(12);
	}

	public void setContinuationPointer(String input) {
		setElement(input, 13);
	}

	public String getContinuationPointer() {
		return getElement(13);
	}

	public void setAcceptAckType(String input) {
		setElement(input, 14);
	}

	public String getAcceptAckType() {
		return getElement(14);
	}

	public void setApplicationAckType(String input) {
		setElement(input, 15);
	}

	public String getApplicationAckType() {
		return getElement(15);
	}

	public void setCountryCode(String input) {
		setElement(input, 16);
	}

	public String getCountryCode() {
		return getElement(16);
	}
}