/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.cache;

import java.io.Serializable;

/**
 * Interface for cache management.
 * 
 * Created May 17, 2006 1:21:11 PM
 * 
 * @author DNS   DNS
 */
public interface CacheManager extends Serializable {
	/**
	 * Returns a cached item bound to the specific key
	 * 
	 * @param key
	 *            A unique key to search for a cached item
	 * @return A cached item
	 */
	public Object getItem(Object key);

	/**
	 * Removes a cached item bound to the specific key from a cache
	 * 
	 * @param key
	 *            A unique key to search for a cached item
	 * @return A removed cached item
	 */
	public Object removeItem(Object key);

	/**
	 * Stores an item bound to the specific key in a cache
	 * 
	 * @param key
	 *            A unique key to search for a cached item
	 * @param value
	 *            An item to be cached
	 */
	public void cacheItem(Object key, Object value);

	/**
	 * Checks if a cached item bound to the specific key is cached
	 * 
	 * @param key
	 *            A unique key to search for a cached item
	 * @return True if found, False otherwise
	 */
	public boolean containsItem(Object key);
}
