/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.batchprocess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Context information about the running execution of a batch process.
 * 
 * Created Feb 16, 2006 1:44:30 PM
 * 
 * @author DNS   DNS
 */
public class DataProcessExecutionContext {
	private ProcessStatistics processStatistics;
	private Object executionArguments;
	private String initiater;
	private List exceptionData = new ArrayList();
	private List processedData = new ArrayList();
	private Map contextData = new HashMap();
	private boolean interrupted;

	/**
	 * @return Returns the processStatistics.
	 */
	public ProcessStatistics getProcessStatistics() {
		return processStatistics;
	}

	/**
	 * @param processStatistics
	 *            The processStatistics to set.
	 */
	public void setProcessStatistics(ProcessStatistics processStatistics) {
		this.processStatistics = processStatistics;
	}

	/**
	 * @return Returns the executionArguments.
	 */
	public Object getExecutionArguments() {
		return executionArguments;
	}

	/**
	 * @param executionArguments
	 *            The executionArguments to set.
	 */
	public void setExecutionArguments(Object executionArguments) {
		this.executionArguments = executionArguments;
	}

	/**
	 * @return Returns the exceptionData.
	 */
	public List getExceptionData() {
		return exceptionData;
	}

	/**
	 * @param exceptionData
	 *            The exceptionData to set.
	 */
	public void setExceptionData(List exceptionData) {
		this.exceptionData = exceptionData;
	}

	/**
	 * @return Returns the processedData.
	 */
	public List getProcessedData() {
		return processedData;
	}

	/**
	 * @param processedData
	 *            The processedData to set.
	 */
	public void setProcessedData(List processedData) {
		this.processedData = processedData;
	}

	/**
	 * @return Returns the contextData.
	 */
	public Map getContextData() {
		return contextData;
	}

	/**
	 * @return Returns the initiater.
	 */
	public String getInitiater() {
		return initiater;
	}

	/**
	 * @param initiater
	 *            The initiater to set.
	 */
	public void setInitiater(String initiater) {
		this.initiater = initiater;
	}

	/**
	 * @return the interrupted
	 */
	public boolean isInterrupted() {
		return interrupted;
	}

	/**
	 * @param interrupted
	 *            the interrupted to set
	 */
	public void setInterrupted(boolean interrupted) {
		this.interrupted = interrupted;
	}
}
