/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.batchprocess;

import java.io.File;

import gov.va.med.fw.io.parser.FileParserListener;

/**
 * Context information about the running execution of a file based batch
 * process.
 * 
 * Created Feb 16, 2006 2:26:21 PM
 * 
 * @author DNS   DNS
 */
public class DataFileProcessExecutionContext extends DataProcessExecutionContext {
	private FileParserListener fileParserListener;
	private File currentFile;
	private String currentRowRawData;

	/**
	 * @return Returns the currentRowRawData.
	 */
	public String getCurrentRowRawData() {
		return currentRowRawData;
	}

	/**
	 * @param currentRowRawData
	 *            The currentRowRawData to set.
	 */
	public void setCurrentRowRawData(String currentRowRawData) {
		this.currentRowRawData = currentRowRawData;
	}

	/**
	 * @return Returns the currentFile.
	 */
	public File getCurrentFile() {
		return currentFile;
	}

	/**
	 * @param currentFile
	 *            The currentFile to set.
	 */
	public void setCurrentFile(File currentFile) {
		this.currentFile = currentFile;
	}

	/**
	 * @return Returns the fileParserListener.
	 */
	public FileParserListener getFileParserListener() {
		return fileParserListener;
	}

	/**
	 * @param fileParserListener
	 *            The fileParserListener to set.
	 */
	public void setFileParserListener(FileParserListener fileParserListener) {
		this.fileParserListener = fileParserListener;
	}

	public boolean hasFileParserListener() {
		return fileParserListener != null;
	}
}
