/**
 * 
 */
package gov.va.med.fw.batchprocess;

import java.util.Map;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.repeat.RepeatStatus;

import gov.va.med.fw.util.Reflector;

/**
 * @author DNS
 * 
 */
public class ConfigurableBatchProcess extends AbstractTasklet {

	private String serviceName;
	private String methodName;
	private Map<String,Object> dataMap = null;
	//private boolean test = true;

	public RepeatStatus execute(StepContribution arg0, ChunkContext arg1) throws Exception{	
		try {
			// find the service and execute the method
			//if (test) throw new Exception("Failure notificaion test");
			Object service = getApplicationContext().getBean(serviceName);
			Object result = Reflector.invoke(service, methodName, getParameters());
			if (result instanceof java.lang.Integer) {
				Integer count = (Integer) result;
				getProcessStatistics().setNumberOfSuccessfulRecords(count);
				getProcessStatistics().setNumberOfTotalRecords(count);
				getProcessStatistics().setNumberOfErrorRecords(0);
			}
		} catch (Exception ex) {
			logger.error("ConfigurableBatchProcess.execute failed", ex);
			arg0.setExitStatus(ExitStatus.FAILED);			
		}
		return RepeatStatus.FINISHED;		
	}

	public String getMethodName() {
		return methodName;
	}

	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}

	public String getServiceName() {
		return serviceName;
	}

	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	public Map<String,Object> getDataMap() {
		return dataMap;
	}

	public void setDataMap(Map<String,Object> dataMap) {
		this.dataMap = dataMap;
	}

	private Object[] getParameters() {
		if (dataMap != null && dataMap.size() > 0) {
			Object[] params = new Object[dataMap.size()];
			int index = 0;
			for (Object obj : dataMap.values()) {
				params[index++] = obj;
			}
			return params;
		} else {
			return null;
		}
	}
}
