/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.batchprocess;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.quartz.Scheduler;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.trigger.TriggerIdentity.DestinationType;

/**
 * Static summary information about a batch process job.
 * 
 * Created Jan 27, 2006 3:52:57 PM
 * 
 * @author DNS   DNS
 */
public class BatchProcessDetail extends AbstractEntity implements Lookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6444897174382204194L;

	private String jobName;

	private String jobDescription;

	private String triggerName;

	private String triggerGroup = "esr.common.static.triggers";

	public static final String DEFAULT_GROUP = Scheduler.DEFAULT_GROUP;

	private String groupName = DEFAULT_GROUP;

	private DestinationType destinationType;

	/**
	 * @return Returns the destinationType.
	 */
	public DestinationType getDestinationType() {
		return destinationType;
	}

	/**
	 * @param destinationType
	 *            The destinationType to set.
	 */
	public void setDestinationType(DestinationType destinationType) {
		this.destinationType = destinationType;
	}

	/**
	 * @return Returns the groupName.
	 */
	public String getGroupName() {
		return groupName;
	}

	public String getJobGroup() {
		return getGroupName();
	}

	/**
	 * @param groupName
	 *            The groupName to set.
	 */
	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	/**
	 * @return Returns the jobName.
	 */
	public String getJobName() {
		return jobName;
	}

	/**
	 * @param jobName
	 *            The jobName to set.
	 */
	public void setJobName(String jobName) {
		this.jobName = jobName;
	}

	protected void buildToString(ToStringBuilder builder) {
		builder.append("jobName", jobName);
		builder.append("groupName", groupName);
		builder.append("destinationType", destinationType);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.lookup.Lookup#getCode()
	 */
	public String getCode() {
		return jobName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.lookup.Lookup#getDescription()
	 */
	public String getDescription() {
		return jobName + " ("
				+ (destinationType != null ? destinationType.getName() : "Unspecified Destination")
				+ ")";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.lookup.Lookup#getName()
	 */
	public String getName() {
		return jobName;
	}

	/**
	 * @return Returns the jobDescription.
	 */
	public String getJobDescription() {
		return jobDescription;
	}

	/**
	 * @param jobDescription
	 *            The jobDescription to set.
	 */
	public void setJobDescription(String jobDescription) {
		this.jobDescription = jobDescription;
	}

	/**
	 * @return Returns the triggerName.
	 */
	public String getTriggerName() {
		if (triggerName != null)
			return triggerName;
		if (jobName != null)
			return jobName + ".trigger";

		return null;
	}

	/**
	 * @param triggerName
	 *            The triggerName to set.
	 */
	public void setTriggerName(String triggerName) {
		this.triggerName = triggerName;
	}

	/**
	 * @return Returns the triggerGroup.
	 */
	public String getTriggerGroup() {
		return triggerGroup;
	}

	/**
	 * @param triggerGroup
	 *            The triggerGroup to set.
	 */
	public void setTriggerGroup(String triggerGroup) {
		this.triggerGroup = triggerGroup;
	}
}
