package gov.va.med.config;

import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;

/**
 * 
 * @author James Garnhart
 * 
 */
@Configuration
@ComponentScan(basePackages = {
		"gov.va.med" }, excludeFilters = @ComponentScan.Filter(type = FilterType.REGEX, pattern = {
				"gov.va\\..*\\.config\\..*", "gov.va\\..*\\.controller\\..*", "gov.va\\..*\\.ui\\..*" }))
@Import({ HibernateConfig.class, WebSecurityConfig.class })
@ImportResource({ "classpath:spring/cchtAppContext.xml" })
public class AppConfiguration {

}
