package gov.va.med.ccht.util;

import java.text.ParseException;
import java.util.Date;

import gov.va.med.ccht.service.common.TerminologyException;
import gov.va.med.ccht.service.common.TerminologyService;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.ui.model.TermType;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;

public class TransferUtils {

	public static Date nullSafeParseDate(String date, String pattern) throws ParseException {
		if (StringUtils.isEmpty(date)) {
			return null;
		} else {
			return DateUtils.parseDate(date, pattern);
		}
	}

	public static <T extends Lookup> T transferTermTypeToLookup(TerminologyService svc,
			Class<T> terminologyType, TermType tt) throws TerminologyException {
		if (tt == null || StringUtils.isEmpty(tt.getValue())) {
			return null;
		} else {
			return svc.getByCode(terminologyType, tt.getValue());
		}
	}

	public static <T extends Lookup> T transferTermTypeCodeToLookup(TerminologyService svc,
			Class<T> terminologyType, String code) throws TerminologyException {
		if (StringUtils.isEmpty(code)) {
			return null;
		} else {
			return svc.getByCode(terminologyType, code);
		}
	}
}
