package gov.va.med.ccht.util;

import java.util.HashMap;
import java.util.Map;

public class ReportUtils {

	private static final Map<String, String> MODALITY_COLUMN_TO_DISPLAY = new HashMap<String,String>();
	private static final Map<String, String> MODALITY_ID_TO_COLUMN = new HashMap<String,String>();
	
	static {
		// Hard coded for now, but should be put into the database.
		// Could have 3 columns in the modality table with id, column, display name
		MODALITY_COLUMN_TO_DISPLAY.put("Patient_Totals", "Total Patients");
		MODALITY_COLUMN_TO_DISPLAY.put("Dialogue", "Messaging Total");
		MODALITY_COLUMN_TO_DISPLAY.put("MessagingByDevice", "Messaging By Device");
		MODALITY_COLUMN_TO_DISPLAY.put("MessagingByIVR", "Messaging By IVR");
		MODALITY_COLUMN_TO_DISPLAY.put("Browser", "Messaging By Browser");
		MODALITY_COLUMN_TO_DISPLAY.put("MessagingUnknown", "Messaging (IVR, device, or browser not yet assigned)");        
		MODALITY_COLUMN_TO_DISPLAY.put("Measurement", "Peripheral Measurements");
		MODALITY_COLUMN_TO_DISPLAY.put("Video", "Video");
		MODALITY_COLUMN_TO_DISPLAY.put("CellModem", "Cellular Modem Transmission");
		MODALITY_COLUMN_TO_DISPLAY.put("Satellite", "Satellite Transmission");
		MODALITY_COLUMN_TO_DISPLAY.put("DigImageCapture", "Digital Image Capture");
		
		MODALITY_ID_TO_COLUMN.put("1", "Dialogue");
		MODALITY_ID_TO_COLUMN.put("2", "Measurement");
		MODALITY_ID_TO_COLUMN.put("3", "Video");
		MODALITY_ID_TO_COLUMN.put("5", "MessagingByIVR");
		MODALITY_ID_TO_COLUMN.put("6", "MessagingByDevice");
		MODALITY_ID_TO_COLUMN.put("7", "CellModem");
		MODALITY_ID_TO_COLUMN.put("8", "Satellite");
		MODALITY_ID_TO_COLUMN.put("9", "DigImageCapture");
		MODALITY_ID_TO_COLUMN.put("10", "MessagingUnknown");
		MODALITY_ID_TO_COLUMN.put("11", "Browser");
	}
	
	public static String getModalityDisplayNameFromColumnName(String modalityColumnName) {
		return MODALITY_COLUMN_TO_DISPLAY.get(modalityColumnName);
	}
    
    public static String getModalityColumnNameFromId(String modalityId) {
    	return MODALITY_ID_TO_COLUMN.get(modalityId);
    }
}
