package gov.va.med.ccht.util;

import java.util.Map;

public class CollectionUtil {

	/**
	 * This method returns the value associated with the specified key in the
	 * specified map. If the value does not exist, the map is populated with the
	 * specified defaultValue and this value is returned.
	 * 
	 * @param <K>
	 *            The type of the key in the map
	 * @param <T>
	 *            The type of the value in the map
	 * @param key
	 *            The key to use in the map
	 * @param map
	 *            The map to search
	 * @param defaultValue
	 *            The default value to insert in the map if the map doesn't yet
	 *            contain the key
	 * @return
	 */
	public static <K, T> T getOrInsert(K key, Map<K, T> map, T defaultValue) {
		T currentValue = map.get(key);
		if (currentValue == null) {
			currentValue = defaultValue;
			map.put(key, currentValue);
		}
		return currentValue;
	}

}