package gov.va.med.ccht.ui.model;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import gov.va.med.ccht.model.AppUserGroup;
import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.common.SimpleFacility;
import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.ccht.model.common.Vendor;
import gov.va.med.ccht.model.terminology.InactiveReason;
import gov.va.med.ccht.model.terminology.RegistrationDeniedReason;
import gov.va.med.ccht.model.terminology.RegistrationReason;
import gov.va.med.ccht.model.terminology.RegistrationStatus;
import gov.va.med.fw.security.SimpleRole;

public class UserRegistrationForm {

	//
	private String fullName;
	private String familyName;
	private String givenName;
	private String middleName;
	private String title;
	private String department;
	private String description;
	private String office;

	private User user;

	// User Name
	private String userName;

	// User ID

	// Email
	private String email;

	// Phone
	private String phone;

	// User Group
	private Map<Integer, String> userGroups;
	private Integer assignedUserGroup;

	// Registration Status
	private Map<Integer, RegistrationStatus> registrationStatusLookUpMap;
	private Map<Integer, String> registrationStatusMap;
	private Long assignedRegistrationStatusId;

	// Job Description
	private Map<Integer, String> jobDescriptionMap;
	private Long assignedJobDescriptionId;

	// Assigned VISN
	private Map<Integer, SimpleVisn> visnLookUp;
	private Map<Integer, String> visns;
	private Integer assignedVisnId;

	// Assigned Facility
	private Map<Integer, SimpleFacility> facilityLookUp;
	private Map<Integer, String> facilities;
	private Integer facilitiesId;

	// Vendor
	private Map<Integer, Vendor> vendorLookUp;
	private Map<Integer, String> vendors;
	private Integer selectedVendorId;

	// User Roles
	private Map<Integer, SimpleRole> allRolesLookUpMap;
	private Map<Integer, String> allRolesMap;
	private List<Integer> allRoles;
	private List<Integer> assignedRoles;

	// Locked
	private boolean locked;

	// Inactivate
	private boolean inactive;

	// Inactivate Date
	private String inactivationDateAsString;

	// Inactivate Reason
	private Map<Integer, String> inactiveReasons;
	private Map<Integer, InactiveReason> inactiveReasonsLookUpMap;
	private Long inactiveReasonId;

	// Registration Denied Reason
	private Map<Integer, RegistrationDeniedReason> registrationDeniedReasonsLookUp;
	private Map<Integer, String> registrationDeniedReasons;
	private Long registrationDeniedReasonId;

	public UserRegistrationForm(User user) {
		this.user = user;
		this.fullName = user.getFullName();
		this.givenName = user.getFirstName();
		this.familyName = user.getLastName();
		this.middleName = user.getMiddleName();
		this.title = user.getTitle();
		this.email = user.getEmail();
		this.phone = user.getTelephoneNumber();
		this.userName = user.getUsername();

		Set<AppUserGroup> temp = user.getUserGroups();

		Vendor assignedVendor = user.getVendor();
		if (assignedVendor != null) {
			this.selectedVendorId = assignedVendor.getId();
		}

		SimpleVisn assignedVisn = user.getVisn();
		if (assignedVisn != null) {
			this.assignedVisnId = assignedVisn.getId();
		}

		SimpleFacility facility = user.getFacility();
		if (facility != null) {
			this.facilitiesId = facility.getId();
		}

		InactiveReason inactiveReason = user.getInactiveReason();
		if (inactiveReason != null) {
			this.inactiveReasonId = inactiveReason.getId();
		}

		RegistrationReason reason = user.getRegistrationReason();
		if (reason != null) {
			this.assignedJobDescriptionId = reason.getId();
		}

		RegistrationStatus registrationStatus = user.getRegistrationStatus();
		if (registrationStatus != null) {
			this.assignedRegistrationStatusId = registrationStatus.getId();
		}
	}

	public Long getAssignedJobDescriptionId() {
		return assignedJobDescriptionId;
	}

	public Long getAssignedRegistrationStatusId() {
		return assignedRegistrationStatusId;
	}

	public Integer getAssignedUserGroup() {
		return assignedUserGroup;
	}

	public Integer getAssignedVisnId() {
		return assignedVisnId;
	}

	public String getEmail() {
		return email;
	}

	public Map<Integer, String> getFacilities() {
		return facilities;
	}

	public Integer getFacilitiesId() {
		return facilitiesId;
	}

	public Map<Integer, SimpleFacility> getFacilityLookUp() {
		return facilityLookUp;
	}

	public String getFullName() {
		return fullName;
	}

	public String getInactivationDateAsString() {
		return inactivationDateAsString;
	}

	public Long getInactiveReasonId() {
		return inactiveReasonId;
	}

	public Map<Integer, String> getInactiveReasons() {
		return inactiveReasons;
	}

	public Map<Integer, String> getJobDescriptionMap() {
		return jobDescriptionMap;
	}

	public String getPhone() {
		return phone;
	}

	public Map<Integer, String> getRegistrationStatusMap() {
		return registrationStatusMap;
	}

	public Integer getSelectedVendorId() {
		return selectedVendorId;
	}

	public User getUser() {
		return user;
	}

	public Map<Integer, String> getUserGroups() {
		return userGroups;
	}

	public String getUserName() {
		return userName;
	}

	public Map<Integer, Vendor> getVendorLookUp() {
		return vendorLookUp;
	}

	public Map<Integer, String> getVendors() {
		return vendors;
	}

	public Map<Integer, SimpleVisn> getVisnLookUp() {
		return visnLookUp;
	}

	public Map<Integer, String> getVisns() {
		return visns;
	}

	public boolean isInactive() {
		return inactive;
	}

	public boolean isLocked() {
		return locked;
	}

	public void setAssignedJobDescriptionId(Long assignedJobDescriptionId) {
		this.assignedJobDescriptionId = assignedJobDescriptionId;
	}

	public void setAssignedRegistrationStatusId(Long assignedRegistrationStatusId) {
		this.assignedRegistrationStatusId = assignedRegistrationStatusId;
	}

	public void setAssignedUserGroup(Integer assignedUserGroup) {
		this.assignedUserGroup = assignedUserGroup;
	}

	public void setAssignedVisnId(Integer assignedVisnId) {
		this.assignedVisnId = assignedVisnId;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public void setFacilities(Map<Integer, String> facilities) {
		this.facilities = facilities;
	}

	public void setFacilitiesId(Integer facilitiesId) {
		this.facilitiesId = facilitiesId;
	}

	public void setFacilityLookUp(Map<Integer, SimpleFacility> facilityLookUp) {
		this.facilityLookUp = facilityLookUp;
	}

	public void setFullName(String fullName) {
		this.fullName = fullName;
	}

	public void setInactivationDateAsString(String inactivationDateAsString) {
		this.inactivationDateAsString = inactivationDateAsString;
	}

	public void setInactive(boolean inactive) {
		this.inactive = inactive;
	}

	public void setInactiveReasonId(Long inactiveReasonId) {
		this.inactiveReasonId = inactiveReasonId;
	}

	public void setInactiveReasons(Map<Integer, String> inactiveReasons) {
		this.inactiveReasons = inactiveReasons;
	}

	public void setJobDescriptionMap(Map<Integer, String> jobDescriptionMap) {
		this.jobDescriptionMap = jobDescriptionMap;
	}

	public void setLocked(boolean locked) {
		this.locked = locked;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public void setRegistrationStatusMap(Map<Integer, String> registrationStatusMap) {
		this.registrationStatusMap = registrationStatusMap;
	}

	public void setSelectedVendorId(Integer selectedVendorId) {
		this.selectedVendorId = selectedVendorId;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public void setUserGroups(Map<Integer, String> userGroups) {
		this.userGroups = userGroups;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public void setVendorLookUp(Map<Integer, Vendor> vendorLookUp) {
		this.vendorLookUp = vendorLookUp;
	}

	public void setVendors(Map<Integer, String> vendors) {
		this.vendors = vendors;
	}

	public void setVisnLookUp(Map<Integer, SimpleVisn> visnLookUp) {
		this.visnLookUp = visnLookUp;
	}

	public void setVisns(Map<Integer, String> visns) {
		this.visns = visns;
	}

	public Map<Integer, SimpleRole> getAllRolesLookUpMap() {
		return allRolesLookUpMap;
	}

	public void setAllRolesLookUpMap(Map<Integer, SimpleRole> allRoles) {
		this.allRolesLookUpMap = allRoles;
	}

	public Map<Integer, String> getAllRolesMap() {
		return allRolesMap;
	}

	public void setAllRolesMap(Map<Integer, String> allRolesMap) {
		this.allRolesMap = allRolesMap;
	}

	public List<Integer> getAssignedRoles() {
		return assignedRoles;
	}

	public void setAssignedRoles(List<Integer> assignedRoles) {
		this.assignedRoles = assignedRoles;
	}

	public List<Integer> getAllRoles() {
		return allRoles;
	}

	public void setAllRoles(List<Integer> allRoles) {
		this.allRoles = allRoles;
	}

	public String getFamilyName() {
		return familyName;
	}

	public void setFamilyName(String familyName) {
		this.familyName = familyName;
	}

	public String getGivenName() {
		return givenName;
	}

	public void setGivenName(String givenName) {
		this.givenName = givenName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDepartment() {
		return department;
	}

	public void setDepartment(String department) {
		this.department = department;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getOffice() {
		return office;
	}

	public void setOffice(String office) {
		this.office = office;
	}

	public Date getAccountExpireDate() {
		return user.getAccountExpireDate();
	}

	public RegistrationReason getRegistrationReason() {
		return user.getRegistrationReason();
	}

	public List<SimpleRole> getAssignedUserRoles() {

		List<SimpleRole> retVal = new LinkedList<SimpleRole>();

		if (assignedRoles != null) {
			for (Integer id : assignedRoles) {
				SimpleRole userRole = allRolesLookUpMap.get(id);
				retVal.add(userRole);
			}
		}

		return retVal;
	}

	public RegistrationStatus getSelectedRegistrationStatus() {

		if (assignedRegistrationStatusId > 0) {
			return registrationStatusLookUpMap.get(assignedRegistrationStatusId);
		} else {
			return null;
		}

	}

	public RegistrationDeniedReason getRegistrationDeniedReason() {
		RegistrationDeniedReason retVal = null;

		if (registrationDeniedReasonId != null) {
			return registrationDeniedReasonsLookUp.get(registrationDeniedReasonId);
		} else {
			return null;
		}
	}

	public InactiveReason getInactiveReason() {

		if (inactiveReasonId > 0) {
			return inactiveReasonsLookUpMap.get(inactiveReasonId);
		} else {
			return null;
		}
	}

	public SimpleVisn getVisn() {

		if (assignedVisnId > 0) {
			return visnLookUp.get(assignedVisnId);
		} else {
			return null;
		}
	}

	public SimpleFacility getFacility() {

		if (facilitiesId > 0) {
			return facilityLookUp.get(facilitiesId);
		} else {
			return null;
		}
	}

	public Vendor getVendor() {
		if (selectedVendorId > 0) {
			return vendorLookUp.get(selectedVendorId);
		} else {
			return null;
		}
	}

	public Date getInactiveDate() {
		return null;
	}

	public Map<Integer, RegistrationStatus> getRegistrationStatusLookUpMap() {
		return registrationStatusLookUpMap;
	}

	public void setRegistrationStatusLookUpMap(Map<Integer, RegistrationStatus> registrationStatusLookUpMap) {
		this.registrationStatusLookUpMap = registrationStatusLookUpMap;
	}

	public Map<Integer, InactiveReason> getInactiveReasonsLookUpMap() {
		return inactiveReasonsLookUpMap;
	}

	public void setInactiveReasonsLookUpMap(Map<Integer, InactiveReason> inactiveReasonsLookUpMap) {
		this.inactiveReasonsLookUpMap = inactiveReasonsLookUpMap;
	}

	public Map<Integer, RegistrationDeniedReason> getRegistrationDeniedReasonsLookUp() {
		return registrationDeniedReasonsLookUp;
	}

	public void setRegistrationDeniedReasonsLookUp(
			Map<Integer, RegistrationDeniedReason> registrationDeniedReasonsLookUp) {
		this.registrationDeniedReasonsLookUp = registrationDeniedReasonsLookUp;
	}

	public Map<Integer, String> getRegistrationDeniedReasons() {
		return registrationDeniedReasons;
	}

	public void setRegistrationDeniedReasons(Map<Integer, String> registrationDeniedReasons) {
		this.registrationDeniedReasons = registrationDeniedReasons;
	}

	public Long getRegistrationDeniedReasonId() {
		return registrationDeniedReasonId;
	}

	public void setRegistrationDeniedReasonId(Long registrationDeniedReasonId) {
		this.registrationDeniedReasonId = registrationDeniedReasonId;
	}

}
