package gov.va.med.ccht.ui.model;

import java.util.HashSet;
import java.util.Set;

import org.springframework.context.support.ApplicationObjectSupport;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.UserPreference;
import gov.va.med.ccht.model.common.Vendor;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.ui.model.TermType;

public class UserPrincipalForm extends ApplicationObjectSupport{
	private Set<String> permissions = null; 
	private String userName = null;
	private String givenName = null;
	private String middleName = null;
	private String familyName = null;
	private String email = null;
	private TermType visn = null;
	private TermType facility = null;
	private TermType secondaryFacility = null;
	private TermType vendor = null;
	//Preferences	
	private Integer appWindowHeight;
	private Integer appWindowWidth;
	private Boolean multipleWindows;
	private Integer maxOpenWindows;
	
	public UserPrincipalForm() {}
	
	public UserPrincipalForm(SecurityContext securityContext) {
		UserPrincipal up = securityContext.getUserPrincipal();
		userName = up.getUsername();
		givenName = up.getFirstName();
		middleName = up.getMiddleName();
		familyName = up.getLastName();
		email = up.getEmail();
		String[] gas = securityContext.getRolesAsStrings();
		permissions = new HashSet<String> ();
		if (gas != null && gas.length > 0) {
			for (String ga:gas) {
				permissions.add(ga);
			}
		}
		if (up instanceof User) {
			User user = (User)up;
			visn = toTermType(user.getVisn());
			facility = toTermType(user.getFacility());
			secondaryFacility = toTermType(user.getSecondaryFacility());
			vendor = toTermType(user.getVendor());
			//Preferences
			setMultipleWindows(getBooleanValue(user.getPreferenceValue(UserPreference.MULTIPLE_WINDOWS),true));
			setMaxOpenWindows(getIntegerValue(user.getPreferenceValue(UserPreference.MAX_OPEN_WINDOWS),0));
			setAppWindowWidth(getIntegerValue(user.getPreferenceValue(UserPreference.APP_WINDOW_WIDTH),0));
			setAppWindowHeight(getIntegerValue(user.getPreferenceValue(UserPreference.APP_WINDOW_HEIGHT),0));
		}
	}
	public Set<String> getPermissions() {
		return permissions;
	}
	public void setPermissions(Set<String> permissions) {
		this.permissions = permissions;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public String getGivenName() {
		return givenName;
	}
	public void setGivenName(String givenName) {
		this.givenName = givenName;
	}
	public String getMiddleName() {
		return middleName;
	}
	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}
	public String getFamilyName() {
		return familyName;
	}
	public void setFamilyName(String familyName) {
		this.familyName = familyName;
	}
	public TermType getVisn() {
		return visn;
	}
	public void setVisn(TermType visn) {
		this.visn = visn;
	}
	public TermType getFacility() {
		return facility;
	}
	public void setFacility(TermType facility) {
		this.facility = facility;
	}
	public TermType getSecondaryFacility() {
		return secondaryFacility;
	}
	public void setSecondaryFacility(TermType secondaryFacility) {
		this.secondaryFacility = secondaryFacility;
	}
	public TermType getVendor() {
		return vendor;
	}
	public void setVendor(TermType vendor) {
		this.vendor = vendor;
	}
	private TermType toTermType(Lookup lookup) {
		TermType term = null;
		if( lookup != null ) {
			if( lookup instanceof Vendor ) {
				term = new TermType(lookup.getName(), String.valueOf(((Vendor)lookup).getId()));
			}
			else {
				term = new TermType(lookup.getName(), lookup.getCode());
			}
		}
		return term;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}

	public Integer getAppWindowHeight() {
		return appWindowHeight;
	}

	public void setAppWindowHeight(Integer appWindowHeight) {
		this.appWindowHeight = appWindowHeight;
	}

	public Integer getAppWindowWidth() {
		return appWindowWidth;
	}

	public void setAppWindowWidth(Integer appWindowWidth) {
		this.appWindowWidth = appWindowWidth;
	}

	public Boolean getMultipleWindows() {
		return multipleWindows;
	}

	public void setMultipleWindows(Boolean multipleWindows) {
		this.multipleWindows = multipleWindows;
	}

	public Integer getMaxOpenWindows() {
		return maxOpenWindows;
	}

	public void setMaxOpenWindows(Integer maxOpenWindows) {
		this.maxOpenWindows = maxOpenWindows;
	}

	private Integer getIntegerValue(String value, Integer defaultValue) {
		try {
			if (value != null) {
				return Integer.parseInt(value);
			}
		}
		catch (Exception e){logger.error("getIntegerValue error:  "+e.getMessage());}
		return defaultValue;
	}
	
	private Boolean getBooleanValue(String value, Boolean defaultValue) {
		try {
			if (value != null) {
				return Boolean.parseBoolean(value);
			}
		}
		catch (Exception e){logger.error("getBooleanValue error:  "+e.getMessage());}
		return defaultValue;
	}
}
