package gov.va.med.ccht.ui.model;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.fw.security.Permission;
import gov.va.med.fw.security.Role;
import gov.va.med.fw.ui.model.Form;

public class RoleForm extends Form {
	private String name;
	private String description;
	private List<Long> permissions;
	private String [] selectedPermissions;

	public RoleForm() {
	}

	public RoleForm(Role r) {
		
		setId(String.valueOf(r.getId()));
		setModifiedBy(r.getRecordModifiedBy());
		
		this.name = r.getName();
		this.description = r.getDescription();
		int index = 0;
		selectedPermissions = new String[r.getPermissions().size()];
		for (Permission p : r.getPermissions()) {
			getPermissions().add(p.getId());
			selectedPermissions[index] = p.getName();
			index++;
		}
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public List<Long> getPermissions() {
		if (permissions == null)
			permissions = new ArrayList<Long>();
		return permissions;
	}

	public void setPermissions(List<Long> permissions) {
		this.permissions = permissions;
	}

	public String[] getSelectedPermissions() {
		return selectedPermissions;
	}

	public void setSelectedPermissions(String[] selectedPermissions) {
		this.selectedPermissions = selectedPermissions;
	}
	
	

}
