/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.ui.model;

import java.util.Date;
import java.util.List;

import gov.va.med.ccht.model.common.ReportWeek;
import gov.va.med.fw.ui.model.Form;
import gov.va.med.fw.ui.model.TermType;

/**
 * 
 * 
 * CCHT
 * 
 * @author DNS
 */
public class ReportParametersForm extends Form {
	
	//Report Parameters
	private Date fromDate;
	private Date toDate;
	private Date asOfDate;
	private TermType reportFormat;
	private TermType reportSummaryType;
	private ReportWeek reportWeek;
	private TermType visn;
	private TermType facility;
	private TermType subTotalType;
	private String facilityId;
	private String reportName;
	public List<TermType> deviceStatuses;
	public Boolean allDeviceStatuses;

	// ------------------ Scheduled Report Date Range fields
	private TermType scheduledReportFromType;
	private Date scheduledReportFromSpecificFixedDate;
	private Integer scheduledReportFromNumUnitsPriorToCurrentDay;
	private TermType scheduledReportFromUnitPriorToCurrentDay;
	private TermType scheduledReportFromFixedDateType;
	private Boolean scheduledReportFromUsePreviousDatePeriod;
	private TermType scheduledReportFromMultiDayTimeUnitType;

	private TermType scheduledReportToType;
	private Date scheduledReportToSpecificFixedDate;
	private Integer scheduledReportToNumUnitsPriorToCurrentDay;
	private TermType scheduledReportToUnitPriorToCurrentDay;
	private TermType scheduledReportToFixedDateType;
	private Boolean scheduledReportToUsePreviousDatePeriod;
	private TermType scheduledReportToMultiDayTimeUnitType;

	private Integer scheduledReportDaysToKeepCompletedReports;

	public Date getAsOfDate() {
		return asOfDate;
	}

	public void setAsOfDate(Date asOfDate) {
		this.asOfDate = asOfDate;
	}

	public Date getFromDate() {
		return fromDate;
	}

	public void setFromDate(Date fromDate) {
		this.fromDate = fromDate;
	}

	public TermType getReportFormat() {
		return reportFormat;
	}

	public void setReportFormat(TermType reportFormat) {
		this.reportFormat = reportFormat;
	}

	public Date getToDate() {
		return toDate;
	}

	public void setToDate(Date toDate) {
		this.toDate = toDate;
	}
	public TermType getReportSummaryType() {
		return reportSummaryType;
	}
	public void setReportSummaryType(TermType reportSummaryType) {
		this.reportSummaryType = reportSummaryType;
	}
	public ReportWeek getReportWeek() {
		return reportWeek;
	}
	public void setReportWeek(ReportWeek reportWeek) {
		this.reportWeek = reportWeek;
	}
	public TermType getVisn() {
		return visn;
	}
	public void setVisn(TermType visn) {
		this.visn = visn;
	}
	public TermType getFacility() {
		return facility;
	}
	public void setFacility(TermType facility) {
		this.facility = facility;
	}
	public TermType getSubTotalType() {
		return subTotalType;
	}
	public void setSubTotalType(TermType subTotalType) {
		this.subTotalType = subTotalType;
	}
	public String getFacilityId() {
		return facilityId;
	}
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	public String getReportName() {
		return reportName;
	}
	public void setReportName(String reportName) {
		this.reportName = reportName;
	}
	public List<TermType> getDeviceStatuses() {
		return deviceStatuses;
	}
	public void setDeviceStatuses(List<TermType> deviceStatuses) {
		this.deviceStatuses = deviceStatuses;
	}
	public Boolean getAllDeviceStatuses() {
		return allDeviceStatuses;
	}
	public void setAllDeviceStatuses(Boolean allDeviceStatuses) {
		this.allDeviceStatuses = allDeviceStatuses;
	}
	public Date getScheduledReportFromSpecificFixedDate() {
		return scheduledReportFromSpecificFixedDate;
	}
	public void setScheduledReportFromSpecificFixedDate(Date scheduledReportFromSpecificFixedDate) {
		this.scheduledReportFromSpecificFixedDate = scheduledReportFromSpecificFixedDate;
	}

	public Integer getScheduledReportFromNumUnitsPriorToCurrentDay() {
		return scheduledReportFromNumUnitsPriorToCurrentDay;
	}

	public void setScheduledReportFromNumUnitsPriorToCurrentDay(
			Integer scheduledReportFromNumUnitsPriorToCurrentDay) {
		this.scheduledReportFromNumUnitsPriorToCurrentDay = scheduledReportFromNumUnitsPriorToCurrentDay;
	}

	public Boolean getScheduledReportFromUsePreviousDatePeriod() {
		return scheduledReportFromUsePreviousDatePeriod;
	}

	public void setScheduledReportFromUsePreviousDatePeriod(
			Boolean scheduledReportFromUsePreviousDatePeriod) {
		this.scheduledReportFromUsePreviousDatePeriod = scheduledReportFromUsePreviousDatePeriod;
	}

	public Date getScheduledReportToSpecificFixedDate() {
		return scheduledReportToSpecificFixedDate;
	}

	public void setScheduledReportToSpecificFixedDate(Date scheduledReportToSpecificFixedDate) {
		this.scheduledReportToSpecificFixedDate = scheduledReportToSpecificFixedDate;
	}

	public Integer getScheduledReportToNumUnitsPriorToCurrentDay() {
		return scheduledReportToNumUnitsPriorToCurrentDay;
	}

	public void setScheduledReportToNumUnitsPriorToCurrentDay(
			Integer scheduledReportToNumUnitsPriorToCurrentDay) {
		this.scheduledReportToNumUnitsPriorToCurrentDay = scheduledReportToNumUnitsPriorToCurrentDay;
	}

	public Boolean getScheduledReportToUsePreviousDatePeriod() {
		return scheduledReportToUsePreviousDatePeriod;
	}

	public void setScheduledReportToUsePreviousDatePeriod(
			Boolean scheduledReportToUsePreviousDatePeriod) {
		this.scheduledReportToUsePreviousDatePeriod = scheduledReportToUsePreviousDatePeriod;
	}

	public TermType getScheduledReportFromType() {
		return scheduledReportFromType;
	}

	public void setScheduledReportFromType(TermType scheduledReportFromType) {
		this.scheduledReportFromType = scheduledReportFromType;
	}

	public TermType getScheduledReportFromUnitPriorToCurrentDay() {
		return scheduledReportFromUnitPriorToCurrentDay;
	}

	public void setScheduledReportFromUnitPriorToCurrentDay(
			TermType scheduledReportFromUnitPriorToCurrentDay) {
		this.scheduledReportFromUnitPriorToCurrentDay = scheduledReportFromUnitPriorToCurrentDay;
	}

	public TermType getScheduledReportFromFixedDateType() {
		return scheduledReportFromFixedDateType;
	}

	public void setScheduledReportFromFixedDateType(TermType scheduledReportFromFixedDateType) {
		this.scheduledReportFromFixedDateType = scheduledReportFromFixedDateType;
	}

	public TermType getScheduledReportFromMultiDayTimeUnitType() {
		return scheduledReportFromMultiDayTimeUnitType;
	}

	public void setScheduledReportFromMultiDayTimeUnitType(
			TermType scheduledReportFromMultiDayTimeUnitType) {
		this.scheduledReportFromMultiDayTimeUnitType = scheduledReportFromMultiDayTimeUnitType;
	}

	public TermType getScheduledReportToType() {
		return scheduledReportToType;
	}

	public void setScheduledReportToType(TermType scheduledReportToType) {
		this.scheduledReportToType = scheduledReportToType;
	}

	public TermType getScheduledReportToUnitPriorToCurrentDay() {
		return scheduledReportToUnitPriorToCurrentDay;
	}

	public void setScheduledReportToUnitPriorToCurrentDay(
			TermType scheduledReportToUnitPriorToCurrentDay) {
		this.scheduledReportToUnitPriorToCurrentDay = scheduledReportToUnitPriorToCurrentDay;
	}

	public TermType getScheduledReportToFixedDateType() {
		return scheduledReportToFixedDateType;
	}

	public void setScheduledReportToFixedDateType(TermType scheduledReportToFixedDateType) {
		this.scheduledReportToFixedDateType = scheduledReportToFixedDateType;
	}

	public TermType getScheduledReportToMultiDayTimeUnitType() {
		return scheduledReportToMultiDayTimeUnitType;
	}

	public void setScheduledReportToMultiDayTimeUnitType(
			TermType scheduledReportToMultiDayTimeUnitType) {
		this.scheduledReportToMultiDayTimeUnitType = scheduledReportToMultiDayTimeUnitType;
	}

	public Integer getScheduledReportDaysToKeepCompletedReports() {
		return scheduledReportDaysToKeepCompletedReports;
	}

	/*
	 * Cairngorm binds 0 if unset since Flex can't have a null Number type; our
	 * validator ensures this is > 0 otherwise CPB
	 */
	public void setScheduledReportDaysToKeepCompletedReports(Integer s) {
		this.scheduledReportDaysToKeepCompletedReports = (s == null || s.equals(new Integer(0))) ? null
				: s;
	}

}
