package gov.va.med.ccht.ui.model;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.web.multipart.MultipartFile;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.common.DeviceType;
import gov.va.med.ccht.model.common.SimpleFacility;
import gov.va.med.ccht.model.common.Vendor;
import gov.va.med.ccht.model.qir.QIRStatusType;
import gov.va.med.fw.ui.model.Form;
import gov.va.med.fw.ui.model.TermType;

public class QIRForm extends Form {

	private String id;
	private TermType dmpQirType;
	private TermType qirType;
	private QIRStatusType qirStatusType;
	private TermType visn;
	private TermType facility;
	private TermType deviceType;
	private TermType vendor;
	private String serialNumber;
	private String purchaseOrderNumber;
	private Date submittedDate;
	private String submittedDateAsString;
	private Date vendorResponseDueDate;
	private Date emailReminderSentDate;
	private Date statusChangeDate;
	private Date lastRepliedDate;

	private String complaint;
	private String headline;
	private String submittedBy;
	private String submittedByName;
	private String remarks;
	private String remarksHistory;
	private String vendorActions;
	private String vendorActionsHistory;
	private String emailSubmittedByName;
	private String isDmpIssue;
	private String facilityNumAndName;
	private List<AttachmentForm> attachments;

	private Map<Integer, Vendor> vendors;

	private Map<Long, Integer> deviceVendorMap;
	private Long selectedDeviceVendor;

	private Integer selectedVendorId;
	private String selectedDmpQirTypeId;

	private Map<String, SimpleFacility> facilities;
	private String selectedFacilityId;

	private Map<Long, DeviceType> devices;
	private int selectedDeviceId;

	private Map<String, String> dmpQirTypes;
	private Long selectedQirType;

	private Map<String, String> qirTypes;

	private MultipartFile[] attachmentFiles;

	private String fromPage;
	private boolean readOnly;

	// ------------------------------------------------- Business Methods

	public boolean isNew() {
		return qirStatusType.getCode().equals(QIRStatusType.NEW);
	}

	public boolean isApproved() {
		return qirStatusType.getCode().equals(QIRStatusType.APPROVED);
	}

	public boolean isWithdrawn() {
		return qirStatusType.getCode().equals(QIRStatusType.WITHDRAWN);
	}

	public boolean isReplied() {
		return qirStatusType.getCode().equals(QIRStatusType.REPLIED);
	}

	public boolean isAgreed() {
		return qirStatusType.getCode().equals(QIRStatusType.AGREED);
	}

	public boolean isClosed() {
		return qirStatusType.getCode().equals(QIRStatusType.CLOSED);
	}

	public boolean isSameSubmittedBy(User user) {
		return getSubmittedBy().equalsIgnoreCase(user.getUsername());
	}

	public boolean isSameVendor(User user) {
		return user.getVendor() != null && vendor.getValue().equals(user.getVendor().getCode());
	}

	public boolean isSameVisn(User user) {
		return user.getVisn() != null && getVisn() != null && user.getVisn().getCode().equals(getVisn().getValue());
	}

	public boolean isSameFacility(User user) {
		return user.getFacility() != null && getFacility() != null
				&& user.getFacility().getCode().equals(getFacility().getValue());
	}

	// ------------------------------------------------- Accessor Methods

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
	
	public TermType getDmpQirType() {
		return dmpQirType;
	}

	public void setDmpQirType(TermType dmpQirType) {
		this.dmpQirType = dmpQirType;
	}

	public String getFromPage() {
		return fromPage;
	}

	public void setFromPage(String fromPage) {
		this.fromPage = fromPage;
	}

	public boolean getReadOnly() {
		return readOnly;
	}

	public void setReadOnly(boolean readOnly) {
		this.readOnly = readOnly;
	}

	public MultipartFile[] getAttachmentFiles() {
		if (attachmentFiles == null)
			attachmentFiles = new MultipartFile[0];
		return attachmentFiles;
	}

	public void setAttachmentFiles(MultipartFile[] attachmentFiles) {
		this.attachmentFiles = attachmentFiles;
	}

	public TermType getQirType() {
		return qirType;
	}

	public void setQirType(TermType qirType) {
		this.qirType = qirType;
	}

	public QIRStatusType getQirStatusType() {
		return qirStatusType;
	}

	public void setQirStatusType(QIRStatusType qirStatusType) {
		this.qirStatusType = qirStatusType;
	}

	public TermType getVisn() {
		return visn;
	}

	public void setVisn(TermType visn) {
		this.visn = visn;
	}

	public TermType getFacility() {
		return facility;
	}

	public void setFacility(TermType facility) {
		this.facility = facility;
	}

	public TermType getDeviceType() {
		return deviceType;
	}

	public void setDeviceType(TermType deviceType) {
		this.deviceType = deviceType;
	}

	public TermType getVendor() {
		return vendor;
	}

	public void setVendor(TermType vendor) {
		this.vendor = vendor;
	}

	public String getSerialNumber() {
		return serialNumber;
	}

	public void setSerialNumber(String serialNumber) {
		this.serialNumber = serialNumber;
	}

	public String getPurchaseOrderNumber() {
		return purchaseOrderNumber;
	}

	public void setPurchaseOrderNumber(String purchaseOrderNumber) {
		this.purchaseOrderNumber = purchaseOrderNumber;
	}

	public Date getSubmittedDate() {
		return submittedDate;
	}

	public void setSubmittedDate(Date submittedDate) {
		this.submittedDate = submittedDate;
	}

	public String getSubmittedDateAsString() {
		return submittedDateAsString;
	}

	public void setSubmittedDateAsString(String submittedDateAsString) {
		this.submittedDateAsString = submittedDateAsString;
	}

	public Date getVendorResponseDueDate() {
		return vendorResponseDueDate;
	}

	public void setVendorResponseDueDate(Date vendorResponseDueDate) {
		this.vendorResponseDueDate = vendorResponseDueDate;
	}

	public Date getEmailReminderSentDate() {
		return emailReminderSentDate;
	}

	public void setEmailReminderSentDate(Date emailReminderSentDate) {
		this.emailReminderSentDate = emailReminderSentDate;
	}

	public Date getStatusChangeDate() {
		return statusChangeDate;
	}

	public void setStatusChangeDate(Date statusChangeDate) {
		this.statusChangeDate = statusChangeDate;
	}

	public String getComplaint() {
		return StringEscapeUtils.unescapeHtml(complaint);	
	}

	public void setComplaint(String complaint) {
		this.complaint = StringEscapeUtils.escapeHtml(complaint);
	}

	public String getHeadline() {
		return headline;
	}

	public void setHeadline(String headline) {
		this.headline = headline;
	}

	public String getSubmittedBy() {
		return submittedBy;
	}

	public void setSubmittedBy(String submittedBy) {
		this.submittedBy = submittedBy;
	}

	public String getSubmittedByName() {
		return submittedByName;
	}

	public void setSubmittedByName(String submittedByName) {
		this.submittedByName = submittedByName;
	}

	public String getRemarks() {
		return StringEscapeUtils.unescapeHtml(remarks);
	}

	public void setRemarks(String remarks) {
		this.remarks = StringEscapeUtils.escapeHtml(remarks);
	}

	public String getRemarksHistory() {
		return remarksHistory;
	}

	public void setRemarksHistory(String remarksHistory) {
		this.remarksHistory = remarksHistory;
	}

	public String getVendorActions() {
		return StringEscapeUtils.unescapeHtml(vendorActions);
	}

	public void setVendorActions(String vendorActions) {
		this.vendorActions = StringEscapeUtils.escapeHtml(vendorActions);
	}

	public String getVendorActionsHistory() {
		return vendorActionsHistory;
	}

	public void setVendorActionsHistory(String vendorActionsHistory) {
		this.vendorActionsHistory = vendorActionsHistory;
	}

	public List<AttachmentForm> getAttachments() {
		return attachments;
	}

	public void setAttachments(List<AttachmentForm> attachments) {
		this.attachments = attachments;
	}

	public String getEmailSubmittedByName() {
		return emailSubmittedByName;
	}

	public void setEmailSubmittedByName(String emailSubmittedByName) {
		this.emailSubmittedByName = emailSubmittedByName;
	}

	public String getFacilityNumAndName() {
		return facilityNumAndName;
	}

	public void setFacilityNumAndName(String facilityNumAndName) {
		this.facilityNumAndName = facilityNumAndName;
	}

	public Date getLastRepliedDate() {
		return lastRepliedDate;
	}

	public void setLastRepliedDate(Date lastRepliedDate) {
		this.lastRepliedDate = lastRepliedDate;
	}

	public String getIsDmpIssue() {
		return isDmpIssue;
	}

	public void setIsDmpIssue(String isDmpIssue) {
		this.isDmpIssue = isDmpIssue;
	}

	public Map<Integer, Vendor> getVendors() {
		return vendors;
	}

	public void setVendors(Map<Integer, Vendor> vendors) {
		this.vendors = vendors;
	}

	public Integer getSelectedVendorId() {
		return selectedVendorId;
	}

	public void setSelectedVendorId(Integer selectedVendorId) {
		this.selectedVendorId = selectedVendorId;
	}

	public Map<String, SimpleFacility> getFacilities() {
		return facilities;
	}

	public void setFacilities(Map<String, SimpleFacility> facilities) {
		this.facilities = facilities;
	}

	public String getSelectedFacilityId() {
		return selectedFacilityId;
	}

	public void setSelectedFacilityId(String selectedFacilityId) {
		this.selectedFacilityId = selectedFacilityId;
	}

	public Map<Long, DeviceType> getDevices() {
		return devices;
	}

	public void setDevices(Map<Long, DeviceType> devices) {
		this.devices = devices;
	}

	public int getSelectedDeviceId() {
		return selectedDeviceId;
	}

	public void setSelectedDeviceId(int selectedDeviceId) {
		this.selectedDeviceId = selectedDeviceId;
	}

	public Long getSelectedQirType() {
		return selectedQirType;
	}

	public void setSelectedQirType(Long selectedQirType) {
		this.selectedQirType = selectedQirType;
	}

	public Map<Long, Integer> getDeviceVendorMap() {
		return deviceVendorMap;
	}

	public void setDeviceVendorMap(Map<Long, Integer> deviceVendorMap) {
		this.deviceVendorMap = deviceVendorMap;
	}

	public Long getSelectedDeviceVendor() {
		return selectedDeviceVendor;
	}

	public void setSelectedDeviceVendor(Long selectedDeviceVendor) {
		this.selectedDeviceVendor = selectedDeviceVendor;
	}

	public Map<String, String> getDmpQirTypes() {
		return dmpQirTypes;
	}

	public void setDmpQirTypes(Map<String, String> dmpQirTypes) {
		this.dmpQirTypes = dmpQirTypes;
	}

	public Map<String, String> getQirTypes() {
		return qirTypes;
	}

	public void setQirTypes(Map<String, String> qirTypes) {
		this.qirTypes = qirTypes;
	}

	public String getSelectedDmpQirTypeId() {

		if (this.selectedDmpQirTypeId == null) {
			setSelectedDmpQirTypeId();
		}

		return selectedDmpQirTypeId;
	}

	public void setSelectedDmpQirTypeId(String selectedDmpQirTypeId) {
		this.selectedDmpQirTypeId = selectedDmpQirTypeId;
	}

	public void setSelectedDmpQirTypeId() {
		if (dmpQirType == null) {
			this.selectedDmpQirTypeId = "-1";
			return;
		}

		this.selectedDmpQirTypeId = dmpQirType.getValue();
	}

}
