package gov.va.med.ccht.ui.common;


import gov.va.med.fw.util.StringUtils;

public class ConversionUtils {

	public static String decorateSSN(String ssn) {
		// decorate with dashes
		String cleanSSN = cleanSSN(ssn);
		StringBuilder formattedSSN = new StringBuilder();
		if (StringUtils.isNotEmpty(cleanSSN) && cleanSSN.length() == 9) {
			formattedSSN.append(cleanSSN.substring(0, 3));
			formattedSSN.append("-");
			formattedSSN.append(cleanSSN.substring(3, 5));
			formattedSSN.append("-");
			formattedSSN.append(cleanSSN.substring(5, 9));
		}
		return formattedSSN.toString();
	}

	public static String cleanSSN(String unformattedSSN) {
		// remove whitespace and dashes
		String temp = unformattedSSN != null ? StringUtils.remove(unformattedSSN, '-') : null;
		temp = temp != null ? StringUtils.remove(temp, ' ') : null;
		return temp;
	}
}
