package gov.va.med.ccht.ui.common;


import java.util.ArrayList;
import java.util.List;

public class ControllerResult {

	public static final String SUCCESS = "SUCCESS";
	public static final String WARNING = "WARNING";
	public static final String ERROR = "ERROR";
	public static final String ALREADY_EXISTS = "ALREADY_EXISTS";
	public static final String DATA_CHANGED = "DATA_CHANGED";

	private String callStatus;
	private List<String> messages;
	private List<String> warnings;
	private List<String> errors;

	public ControllerResult() {
		super();
	}
	
	public ControllerResult(String callStatus) {
		super();
		this.callStatus = callStatus;
	}
	
	public ControllerResult(String callStatus, String errorMessage) {
		super();
		this.callStatus = callStatus;
		if (errorMessage != null) {
			addError(errorMessage);
		}
	}

	public String getCallStatus() {
		return callStatus;
	}

	public void setCallStatus(String callStatus) {
		this.callStatus = callStatus;
	}

	public List<String> getMessages() {
		return messages;
	}

	public void addMessage(String message) {
		if (messages == null) {
			messages = new ArrayList<String>();
		}
		messages.add(message);
	}

	public void setMessages(List<String> messages) {
		this.messages = messages;
	}

	public List<String> getWarnings() {
		return warnings;
	}

	public void addWarning(String warning) {
		if (warnings == null) {
			warnings = new ArrayList<String>();
		}
		warnings.add(warning);
	}

	public void setWarnings(List<String> warnings) {
		this.warnings = warnings;
	}

	public List<String> getErrors() {
		return errors;
	}

	public void addError(String error) {
		if (errors == null) {
			errors = new ArrayList<String>();
		}
		errors.add(error);
	}

	public void setErrors(List<String> errors) {
		this.errors = errors;
	}
}
