package gov.va.med.ccht.ui.ajax;

import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.stereotype.Service;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

@Service
public class WebValidationService {

	@Autowired
	private MessageSource messageSource;

	public void handle(Throwable e, BindingResult result, String defaultMessage) {
		result.addError(new ObjectError(result.getObjectName(), defaultMessage));
	}

	/**
	 * 
	 * @param retMap
	 */
	public void populateAjaxMap(MessageSourceResolvable e, Map<String, Object> retMap) {
		retMap.put(AjaxRequestHandler.AJAX_STATUS_MESSAGE_KEY, messageSource.getMessage(e, Locale.getDefault()));
	}

}
