package gov.va.med.ccht.service.scheduleJob.impl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Service;

import gov.va.med.ccht.persistent.JobDAO;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.ccht.service.scheduleJob.ScheduleJobService;
import gov.va.med.fw.model.batchprocess.JobConfig;
import gov.va.med.fw.model.batchprocess.JobResult;
import gov.va.med.fw.service.ServiceException;

@Service
public class ScheduleJobServiceImpl extends AbstractBusinessService implements ScheduleJobService {

	@Autowired
	private JobDAO jobDao;
	
	@Autowired
	@Qualifier("JobExecutedMessage")
	private SimpleMailMessage jobExecutedMessage;
	
	@Override
	public void sendExecuteNotificationMail(String jobName) throws ServiceException {
		try {
			JobConfig job = jobDao.findJobConfigs(jobName).get(0);
			JobResult jobResult = jobDao.findJobResultsByName(jobName).get(0);
			String emailListString = job.getEmailDistributionList();
			String[]  emailList = emailListString.split(",");
			if (emailList.length > 0) {
				Map<String, Object> data = new HashMap<String, Object>();
				data.put("statistics", jobResult.getStatistics().replaceAll("\\n", "<br/>"));
				data.put("name", jobResult.getName());
				
				SimpleMailMessage template = processMailTemplate(data, jobExecutedMessage);
				template.setTo(emailList);
				send(template);
			}
		} catch (ServiceException e) {
			logger.error("ScheduleJob Service : sendExecuteMail Failed", e);
		}

	}
	
	protected void setJobDao(JobDAO jobDao){
		this.jobDao = jobDao;
	}
	
	protected void setJobExecutedMessage(SimpleMailMessage jobExecutedMessage){
		this.jobExecutedMessage = jobExecutedMessage;
	}

}
