/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.ccht.service.report;

// Java classes
import java.util.Map;

import org.apache.commons.lang3.ClassUtils;

import gov.va.med.ccht.model.report.ReportSetup;
import gov.va.med.fw.security.UserPrincipal;

/**
 * 
 * 
 * Project: Common</br> Created on: 2:12:09 PM </br>
 * 
 * @author DNS
 */
public class StandardReportCriteria extends CommonCriteria {

	private static final String REPORT_SETUP = ClassUtils.getShortClassName(ReportSetup.class);
	private static final String REPORT_USER = ClassUtils.getShortClassName(UserPrincipal.class);

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -438223299183331564L;

	/**
	 * A default constructor
	 */
	public StandardReportCriteria() {
		super();
	}

	/**
	 * A default constructor
	 * 
	 * @param criteria
	 */
	public StandardReportCriteria(Map criteria) {
		super(criteria);
	}

	public void setReportSetup(ReportSetup setup) {
		this.addCriterion(REPORT_SETUP, setup);
	}

	public ReportSetup getReportSetup() {
		Object criterion = this.getCriteria().get(REPORT_SETUP);
		return criterion instanceof ReportSetup ? (ReportSetup) criterion : null;
	}

	public void setReportUser(UserPrincipal setup) {
		this.addCriterion(REPORT_USER, setup);
	}

	public UserPrincipal getReportUser() {
		Object criterion = this.getCriteria().get(REPORT_USER);
		return criterion instanceof UserPrincipal ? (UserPrincipal) criterion : null;
	}

}