/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.ccht.service.report;

import gov.va.med.ccht.model.report.ReportSetup;
// Framework classes
import gov.va.med.fw.report.ConfigurableReportBuilder;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.report.data.ReportDataService;

// ESR classes

/**
 * Allows concrete report builder implementations to be configured through
 * spring context file
 * 
 * Project: Framework</br> Created on: 4:59:46 PM </br>
 * 
 * @author DNS
 */
public class StandardReportBuilder extends ConfigurableReportBuilder {

	private static final long serialVersionUID = -5393606047148762963L;

	public StandardReportBuilder(final ReportDataService reportDataService) {
		super(reportDataService);
	}

	/**
	 * @see gov.va.med.fw.report.ReportBuilder#buildReport(gov.va.med.fw.report.ReportConfiguration)
	 */
	public void buildReport(ReportConfiguration configuration) throws ReportException {
		super.buildReport(setReportSetupCopy(configuration));
	}

	/**
	 * @see gov.va.med.fw.report.ReportBuilder#buildReport(gov.va.med.fw.report.ReportConfiguration,
	 *      gov.va.med.fw.report.data.ReportData)
	 */
	public void buildReport(ReportConfiguration configuration, ReportData data)
			throws ReportException {
		super.buildReport(setReportSetupCopy(configuration), data);
	}

	/**
	 * @see gov.va.med.fw.service.AbstractComponent#afterPropertiesSet()
	 */
	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
	}

	/**
	 * 
	 * @param configuration
	 * @throws ReportException
	 */
	protected ReportConfiguration setReportSetupCopy(ReportConfiguration configuration)
			throws ReportException {
		QueryCriteria criteria = configuration.getQueryCriteria();
		StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria) criteria
				: null;
		if(reportCriteria != null){
			ReportSetup reportSetup = reportCriteria.getReportSetup();
			ReportSetup reportSetupCopy = getReportSetupCopy(reportSetup);
			reportCriteria.setReportSetup(reportSetupCopy);
		}
			return configuration;
	}

	/**
	 * This method returns copy of getReportSetup.
	 * 
	 * @param config
	 * @return
	 * @throws ReportException
	 */
	protected ReportSetup getReportSetupCopy(ReportSetup reportSetup) throws ReportException {
		ReportSetup newReportSetup = null;
		if (reportSetup != null) {
			newReportSetup = new ReportSetup();
		}
		return newReportSetup;
	}

}