/********************************************************************
 * Copyright 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.report;

/**
 * Constants for report actions.
 * 
 * @author Muddaiah Ranga
 * @version 1.0
 */
public interface ReportConstants {

	public static final String REPORT_PARAM_FROM_DATE = "fromDate";
	public static final String REPORT_PARAM_TO_DATE = "toDate";
	public static final String REPORT_PARAM_AS_OF_DATE = "asOfDate";
	public static final String REPORT_PARAM_REPORT_WEEK = "reportWeek";
	public static final String REPORT_PARAM_USER_TIMEZONE = "userTimeZone";
	public static final String REPORT_PARAM_USER = "reportUser";
	public static final String REPORT_PARAM_REPORT_FORMAT = "reportFormat";
	public static final String REPORT_SUMMARY_TYPE = "reportSummaryType";
	public static final String REPORT_PARAM_SUBTOTAL_TYPE = "subTotalType";
	public static final String REPORT_PARAM_VISN = "visn";
	public static final String REPORT_PARAM_ALL_VISNS = "allVisn";
	public static final String REPORT_PARAM_FACILITY = "facility";
	public static final String REPORT_PARAM_ALL_FACILITIES = "allFacilities";
	public static final String REPORT_PARAM_FILE_TYPE = "fileType";
	public static final String REPORT_PARAM_GENERATE_REPORT = "generateReport";
	public static final String REPORT_PARAM_EMAIL_REPORT_TO = "emailReportTo";
	public static final String REPORT_PARAM_ALL_DEVICE_STATUSES ="allDeviceStatuses";
	public static final String REPORT_PARAM_DEVICE_STATUSES ="deviceStatuses";
	public static final int REPORT_DATE_BY_MONTH = 1;
	public static final int REPORT_DATE_BY_QUARTER = 2;
	public static final int REPORT_DATE_BY_FISCAL = 3;
	
	public static final String ACTIVE = "Active";
	public static final String ARCHIVED = "Archived";

	public static final String REPORT_PARAMETERS = "reportParameters";
	public static final String REPORT_SCHEDULE = "reportSchedule";
	public static final String REPORT_SETUP_ID = "reportSetupId";
	public static final String REPORT_SETUP = "reportSetup";
	public static final String REPORT_STANDARD_TYPE = "standardReportType";
	
	public static final String REPORT_SUMMARY_TYPE_NATIONAL = "National";
	public static final String REPORT_SUMMARY_TYPE_VISN = "VISN";
	public static final String ALL_VISN = "-1";
	public static final String REPORT_SUMMARY_TYPE_FACILITY = "Facility";	
	
	public static final String REPORT_SUB_TOTAL_TYPE_VENDOR  = "Vendor";
	public static final String REPORT_SUB_TOTAL_TYPE_DEVICE = "Device";
	public static final String DAYS_TO_KEEP_COMPLETED_REPORTS = "daysToKeepCompletedReports";
	
	public static final Integer MAX_QUESTION_NUMBER = 8;
	public static final String PSS_ALL_COC = "-1";
	public static final String PSS_ALL_COC_EXCEPT_L2 = "-2";
	public static final String PSS_ALL_MOD = "-1";
	public static final String PSS_MOD_DNI = "-2";
	public static final int PSS_PAT_SAT_VERSION_1 = 1;
	public static final int PSS_PAT_SAT_VERSION_2 = 2;
	public static final double PSS_PAT_SAT_V_1_RATING_SCALE = 5.0;
	public static final double PSS_PAT_SAT_V_2_RATING_SCALE = 4.0;
	public static final int MONTH_ID = 1;
	public static final int QTR_ID = 2;
	public static final int YEAR_ID = 3;
	public static final String EMPTY_STRING = "";
	public static final String Q1 = "1";
	public static final String Q2 = "2";
	public static final String Q3 = "3";
	public static final String Q4 = "4";
	public static final int FISCAL_START = 10;
	public static final int FISCAL_END = 9;
	public static final String FISCAL_START_STR = "10";
	public static final String FISCAL_END_STR = "09";
	public static final int Q1_START = 10;
	public static final int Q1_END = 12;
	public static final int Q2_START = 1;
	public static final int Q2_END = 3;
	public static final int Q3_START = 4;
	public static final int Q3_END = 6;
	public static final int Q4_START = 7;
	public static final int Q4_END = 9;
	public static final String Q1_START_STR = "10";
	public static final String Q1_END_STR = "12";
	public static final String Q2_START_STR = "01";
	public static final String Q2_END_STR = "03";
	public static final String Q3_START_STR = "04";
	public static final String Q3_END_STR = "06";
	public static final String Q4_START_STR = "07";
	public static final String Q4_END_STR = "09";
	public static final int NUM_QTRS = 4;
	public static final String YEAR = "yyyy";
	public static final int YEAR_ROLLBACK = -1;
	public static final int YEAR_ROLLUP = 1;
	public static final int YEAR_INCR = 1;
	public static final int FROM = 0;
	public static final int TO = 1;
	public static final int ZERO = 0;
	public static final int ONE = 1;
	public static final int TWO = 2;
	public static final int THREE = 3;
	public static final int FOUR = 4;
	public static final int FIVE = 5;
	public static final int SIX = 6;
	public static final int SEVEN = 7;
	public static final int NINE = 9;
	public static final int TEN = 10;
	public static final int SEPT = 8;
	public static final int OCT = 9;
	public static final int THIRTY = 30;
	public static final int BRWSR = 0;
	public static final Double DUB_INIT = 0.0;
	public static final Integer INT_INIT = 0;
	public static final String BRWSR_ID = "11503";
	public static final String DEVICE_ID = "11501";
	public static final String IVR_ID = "11502";
	public static final String BRWSR_STR = "Browser";
	public static final String DEVICE_STR = "Home Device";
	public static final String IVR_STR = "IVR";
	public static final String TOTALS_STR = "Total";
	public static final int H_DEVICE = 1;
	public static final int I_V_R = 2;
	public static final int TOTALS = 3;
	public static final int Q_SIZE = 8;
	public static final int QUESTION_CNT_START= 1;
	public static final int MONTH_COUNT= 12;
	public static final int NUM_MODS= 4;
}
