/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.ccht.service.report;

// Java classes
import java.util.Date;
import java.util.Map;

import gov.va.med.fw.report.data.QueryCriteria;

// ESR classes

/**
 * Project: Common
 * 
 * @created: 2:12:09 PM </br>
 * @author DNS
 */
public class CommonCriteria extends QueryCriteria {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2824659588794669178L;

	public static final String START_DATE = "startDate";
	public static final String END_DATE = "endDate";
	public static final String RUN_DATE = "runDate";
	public static final String REPORT_TYPE = "Type";
	public static final String REPORT_TITLE = "Title";
	public static final String REPORT_PERIOD = "Period";
	public static final String REPORT_TYPE_CODE = "Type_Code";
	public static final String EMAIL = "email";
	public static final String AS_OF_DATE = "asOfDate";
	public static final String IS_NO_VISN = "noVISN";
	public static final String FILE_TYPE = "fileType";

	/**
	 * A default constructor
	 */
	public CommonCriteria() {
		super();
	}

	/**
	 * A default constructor
	 * 
	 * @param criteria
	 */
	public CommonCriteria(Map criteria) {
		super(criteria);
	}

	public void setFileType(String fileType) {
		this.addCriterion(FILE_TYPE, fileType);
	}

	public void setStartDate(Date date) {
		this.addCriterion(START_DATE, date);
	}

	public void setReportPeriodType(String type) {
		this.addCriterion(REPORT_TYPE, type);
	}

	public void setReportPeriodTypeCode(String code) {
		this.addCriterion(REPORT_TYPE_CODE, code);
	}

	public void setReportPeriod(String period) {
		this.addCriterion(REPORT_PERIOD, period);
	}

	public void setEndDate(Date date) {
		this.addCriterion(END_DATE, date);
	}

	public void setRunDate(Date date) {
		this.addCriterion(RUN_DATE, date);
	}

	public void setAsOfDate(Date date) {
		this.addCriterion(AS_OF_DATE, date);
	}

	public Date getStartDate() {
		Object criterion = this.getCriteria().get(START_DATE);
		return criterion instanceof Date ? (Date) criterion : null;
	}

	public Date getEndDate() {
		Object criterion = this.getCriteria().get(END_DATE);
		return criterion instanceof Date ? (Date) criterion : null;
	}

	public Date getRunDate() {
		Object criterion = this.getCriteria().get(RUN_DATE);
		return criterion instanceof Date ? (Date) criterion : null;
	}

	public String getReportPeriodType() {
		Object criterion = this.getCriteria().get(REPORT_TYPE);
		return criterion instanceof String ? (String) criterion : null;
	}

	public String getReportPeriodTypeCode() {
		Object criterion = this.getCriteria().get(REPORT_TYPE_CODE);
		return criterion instanceof String ? (String) criterion : null;
	}

	public String getReportPeriod() {
		Object criterion = this.getCriteria().get(REPORT_PERIOD);
		return criterion instanceof String ? (String) criterion : null;
	}

	public Date getAsOfDate() {
		Object criterion = this.getCriteria().get(AS_OF_DATE);
		return criterion instanceof Date ? (Date) criterion : null;
	}
}