package gov.va.med.ccht.service.htreports.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ccht.model.responserate.ResponseRateResults;
import gov.va.med.ccht.persistent.ResponseRateReportDAO;
import gov.va.med.ccht.service.htreports.ResponseRateReportService;
import gov.va.med.ccht.ui.model.CensusActivityReportForm;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

@Service
public class ResponseRateReportServiceImpl implements ResponseRateReportService {
	@Autowired
	private ResponseRateReportDAO responseRateReportDAO;

	@Override
	public ResponseRateResults getTopLevelReport(CensusActivityReportForm form) throws ServiceException {
		try {
			return responseRateReportDAO.getTopLevelReport(form);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}
	
	@Override
	public ResponseRateResults getVisnDrillDown(CensusActivityReportForm form) throws ServiceException {
		try {
			return responseRateReportDAO.getVisnDrillDownReport(form);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}
}
