package gov.va.med.ccht.service.htreports.impl;


import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ccht.model.car.CensusActivityRecord;
import gov.va.med.ccht.model.car.CensusActivitySubTotalRecord;
import gov.va.med.ccht.model.car.CensusActivityVisnRecord;
import gov.va.med.ccht.model.common.Visn;
import gov.va.med.ccht.model.report.AggregateModality;
import gov.va.med.ccht.persistent.CensusActivityReportDAO;
import gov.va.med.ccht.persistent.ReportsDAO;
import gov.va.med.ccht.service.common.vendor.VendorService;
import gov.va.med.ccht.service.common.visn.VisnService;
import gov.va.med.ccht.service.htreports.CensusActivityReportService;
import gov.va.med.ccht.ui.model.CensusActivityReportForm;
import gov.va.med.cds.ars.ARService;
import gov.va.med.cds.ars.AggregateReportingServiceInterface;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;


@Service
public class CensusActivityReportServiceImpl implements CensusActivityReportService {
	@Autowired
	private CensusActivityReportDAO censusActivityReportDAO;
	@Autowired
	private VendorService vendorService;
	@Autowired
	private ReportsDAO reportsDAO;
	@Autowired
	private VisnService visnService;
	
	private String hdrEndpoint;
	private ARService arService;
	AggregateReportingServiceInterface arServicePort;
	
	public CensusActivityReportServiceImpl() {
	}
	
	public CensusActivityReportServiceImpl(CensusActivityReportDAO censusActivityReportDAO,
			VendorService vendorService, ReportsDAO reportsDAO, VisnService visnService) {
		this.censusActivityReportDAO = censusActivityReportDAO;
		this.vendorService = vendorService;
		this.reportsDAO = reportsDAO;
		this.visnService = visnService;
	}

	public CensusActivityReportDAO getCensusActivityReportDAO() 
	{
		return censusActivityReportDAO;
	}

	public void setCensusActivityReportDAO(CensusActivityReportDAO censusActivityReportDAO) 
	{
		this.censusActivityReportDAO = censusActivityReportDAO;
	}

	public String getHdrEndpoint() {
		return hdrEndpoint;
	}

	public void setHdrEndpoint(String hdrEndpoint) {
		this.hdrEndpoint = hdrEndpoint;
	}

	public ARService getArService() {
		return arService;
	}

	public void setArService(ARService arService) {
		this.arService = arService;
	}

	public AggregateReportingServiceInterface getArServicePort() {
		return arServicePort;
	}

	public void setArServicePort(AggregateReportingServiceInterface arServicePort) {
		this.arServicePort = arServicePort;
	}

	public CensusActivityRecord getAllVendorsReportStatus() throws ServiceException
	{
		// Previous HDR code was commented out here, can be referenced in the RTC history.
		try 
		{
			return censusActivityReportDAO.getAllVendorsReportStatus();
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
		
	}
	
	@Override
	public  List<CensusActivityRecord> getNationalReport(CensusActivityReportForm form)
			throws ServiceException, ParseException {
		try 
		{
			if(!form.getModalityCode().equals("-1")) {
				// If a modality is selected
				// Get the modality column name
				AggregateModality mod = reportsDAO.getAggregateModalityByCode(form.getModalityCode());
				form.setModalityColumnName(mod.getName());
				form.setModalityDescription(mod.getDescription());
				if(form.getVendorId().equals("-1")) {
					return censusActivityReportDAO.getNationalReportByModality(form);
				}
				else {
					// Get the name of the Vendor
					form.setVendorColumnName(
							vendorService.getVendorById(Long.parseLong(form.getVendorId())).getName());
					return censusActivityReportDAO.getNationalReportByModalityAndVendor(form);
				}
			}
			else if(!form.getVendorId().equals("-1")) {
				// If only a vendor was selected
				form.setVendorColumnName(
						vendorService.getVendorById(Long.parseLong(form.getVendorId())).getName());
				return censusActivityReportDAO.getNationalReportByVendor(form);
			}
			// If neither were selected.
			return censusActivityReportDAO.getNationalReport(form);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}	
	}
	
	@Override
	public List<CensusActivitySubTotalRecord> getSubTotaledNationalReport(CensusActivityReportForm form)throws ServiceException, ParseException {
		try 
		{
			if(!form.getModalityCode().equals("-1")) {
				// If a modality is selected
				// Get the modality column name
				AggregateModality mod = reportsDAO.getAggregateModalityByCode(form.getModalityCode());
				form.setModalityColumnName(mod.getName());
				form.setModalityDescription(mod.getDescription());
				if(form.getVendorId().equals("-1")) {
					return censusActivityReportDAO.getSubtotaledNationalReportByModality(form);
				}
				else {
					throw new ServiceException("Vendor subtotals are not shown when a vendor is selected.");
				}
			}
			else if(!form.getVendorId().equals("-1")) {
				// If only a vendor was selected
				throw new ServiceException("Vendor subtotals are not shown when a vendor is selected.");
			}
			// If neither were selected.
			return censusActivityReportDAO.getSubTotaledNationalReport(form);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}	
	}
	
	@Override
	public  List<CensusActivityVisnRecord> getVisnReport(CensusActivityReportForm form)
			throws ServiceException, ParseException {
		try 
		{
			List<Visn> visns = new ArrayList<Visn>();
			if(form.getVisnId().equals("-1")) {
				visns = visnService.getVisns();
			}
			else {
				visns.add(visnService.getVisnById(new Long(form.getVisnId())));
			}
			if(!form.getModalityCode().equals("-1")) {
				// If a modality is selected
				List<AggregateModality> modality = new ArrayList<AggregateModality>();
				modality.add(reportsDAO.getAggregateModalityByCode(form.getModalityCode()));
				if(!form.getVendorId().equals("-1")) {
					// Get the name of the Vendor
					form.setVendorColumnName(
							vendorService.getVendorById(Long.parseLong(form.getVendorId())).getName());
				}
				return censusActivityReportDAO.getVisnReport(form, modality);
			}
			else if(!form.getVendorId().equals("-1")) {
				// If only a vendor was selected
				form.setVendorColumnName(
						vendorService.getVendorById(Long.parseLong(form.getVendorId())).getName());
				return censusActivityReportDAO.getVisnReport(form, reportsDAO.getAggregateModalities());
			}
			// If neither were selected.
			return censusActivityReportDAO.getVisnReport(form, reportsDAO.getAggregateModalities());
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}	
	}
	
	@Override
	public List<CensusActivityVisnRecord> getSubtotaledVisnReport(CensusActivityReportForm form)throws ServiceException, ParseException {
		try 
		{
			if(form.getModalityCode().equals("-1")) {
				return censusActivityReportDAO.getSubtotaledVisnReport(form, reportsDAO.getAggregateModalities());
			}
			else {
				List<AggregateModality> modality = new ArrayList<AggregateModality>();
				modality.add(reportsDAO.getAggregateModalityByCode(form.getModalityCode()));
				return censusActivityReportDAO.getSubtotaledVisnReport(form, modality);
			}
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}	
	}
	
	@Override
	public List<CensusActivityVisnRecord> getVisnDrilldownData(
			CensusActivityReportForm form) throws ServiceException {
		try 
		{
			if(form.getModalityCode().equals("-1")) {
				return censusActivityReportDAO.getVisnDrilldownData(form, reportsDAO.getAggregateModalities());
			}
			else {
				List<AggregateModality> modality = new ArrayList<AggregateModality>();
				modality.add(reportsDAO.getAggregateModalityByCode(form.getModalityCode()));
				return censusActivityReportDAO.getVisnDrilldownData(form, modality);
			}
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
		catch (Exception e)
		{
			throw new ServiceException(e.getMessage(), e);
		}
	}
	
	@Override
	public List<CensusActivityVisnRecord> getSubtotaledFacilityReport(
			CensusActivityReportForm form) throws ServiceException {
		try 
		{
			if(form.getModalityCode().equals("-1")) {
				return censusActivityReportDAO.getSubtotaledFacilityReport(form, reportsDAO.getAggregateModalities());
			}
			else {
				List<AggregateModality> modality = new ArrayList<AggregateModality>();
				modality.add(reportsDAO.getAggregateModalityByCode(form.getModalityCode()));
				return censusActivityReportDAO.getSubtotaledFacilityReport(form, modality);
			}
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}	
	}
	
	@Override
	public Date getMinStartDate() throws ServiceException {
		try{
			return censusActivityReportDAO.getMinStartDate();
		}
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public AggregateModality getModalityByCode(String code) throws ServiceException {
		return reportsDAO.getAggregateModalityByCode(code);
	}
}
