package gov.va.med.ccht.service.htreports.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ccht.model.coc.CategoryOfCareRecord;
import gov.va.med.ccht.persistent.CategoryOfCareReportDAO;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.ccht.service.htreports.CategoryOfCareReportService;
import gov.va.med.ccht.ui.model.CensusActivityReportForm;

@Service
public class CategoryOfCareReportServiceImpl extends AbstractBusinessService implements CategoryOfCareReportService
{
	@Autowired
    private CategoryOfCareReportDAO categoryOfCareReportDAO;

    public CategoryOfCareReportDAO getCategoryOfCareReportDAO()
    {
        return categoryOfCareReportDAO;
    }

    public void setCategoryOfCareReportDAO(CategoryOfCareReportDAO categoryOfCareReportDAO)
    {
        this.categoryOfCareReportDAO = categoryOfCareReportDAO;
    }
    
    @Override
    public List<CategoryOfCareRecord> getNationalReport(CensusActivityReportForm form)	{
		return categoryOfCareReportDAO.getNationalReport(form);
	} 
    
    @Override
    public List<CategoryOfCareRecord> getVisnReport(CensusActivityReportForm form) {
    	return categoryOfCareReportDAO.getVisnReport(form);
    }
    
    @Override
    public List<CategoryOfCareRecord> getFacilityReportByVisn(CensusActivityReportForm form) {
    	return categoryOfCareReportDAO.getFacilityReportByVisn(form);
    }
    
    @Override
    public List<CategoryOfCareRecord> getFacilityReport(CensusActivityReportForm form) {
    	return categoryOfCareReportDAO.getFacilityReport(form);
    }

}
