package gov.va.med.ccht.service.common.vendor.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ccht.model.common.Vendor;
import gov.va.med.ccht.persistent.VendorDAO;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.ccht.service.common.vendor.VendorService;
import gov.va.med.fw.service.ServiceException;

@Service
public class VendorServiceImpl  extends AbstractBusinessService implements VendorService {

	@Autowired
	private VendorDAO vendorDao;
	
	@Override
	public List<Vendor> getActiveVendors() throws ServiceException {
		try {
			return vendorDao.getActiveVendors();
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public Vendor getVendor(String name) throws ServiceException {
		try {
			return vendorDao.getVendor(name);
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}
	
	@Override
	public Vendor getVendorById(Long id) throws ServiceException {
		try {
			return vendorDao.getVendorById(id);
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}
	
	@Override
	public List<Vendor> getAllVendors() throws ServiceException {
		try {
			return vendorDao.getAllVendors();
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

}
