package gov.va.med.ccht.service.common.reports.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Service;

import gov.va.med.ccht.model.common.ReportWeek;
import gov.va.med.ccht.model.report.AggregateModality;
import gov.va.med.ccht.persistent.ReportsDAO;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.ccht.service.common.reports.ReportService;
import gov.va.med.fw.service.ServiceException;

@Service
public class ReportServiceImpl  extends AbstractBusinessService implements ReportService {

	@Autowired
	private ReportsDAO reportsDao;
	@Resource(name="weeklyVCReportMessage")
	private SimpleMailMessage weeklyVCReportMessage;
	
	private long numberWeeksToDisplay = 0;
	private Date reportingStartDate;
	
	public ReportServiceImpl(){
	}
	
	public ReportServiceImpl(long numWeeks, Date startDate){
		numberWeeksToDisplay = numWeeks;
		reportingStartDate = startDate;
	}
	
	@Override
	public List<ReportWeek> getReportWeeks() throws ServiceException {

		long weeks = getNumberWeeksToDisplay();

		// last weekend (Recent Saturday)
		Calendar weekend = getLastWeekend();

		// Week start
		Calendar weekstart = Calendar.getInstance();
		weekstart.setTime(weekend.getTime());
		weekstart.add(Calendar.DAY_OF_MONTH, -6);

		List<ReportWeek> reportWeeks = new ArrayList<ReportWeek>();

		for (int i = 0; i < weeks; i++) {
			ReportWeek reportWeek = new ReportWeek(weekstart.getTime(), weekend.getTime());
			reportWeeks.add(reportWeek);
			weekstart.add(Calendar.DAY_OF_MONTH, -7);
			weekend.add(Calendar.DAY_OF_MONTH, -7);
		}

		return reportWeeks;
	}
	
	@Override
	public List<AggregateModality> getAggregateModalities() {
		return reportsDao.getAggregateModalities();
	}

	public long getNumberWeeksToDisplay() {
		if (numberWeeksToDisplay > 0) {
			return numberWeeksToDisplay;
		} else {
			return (new Date().getTime() - getReportingStartDate().getTime()) / (24 * 60 * 60 * 1000) / 7;
		}
	}
	
	private Calendar getLastWeekend() {
		Calendar weekend = Calendar.getInstance();
		weekend.set(Calendar.MILLISECOND, 0);
		weekend.set(Calendar.SECOND, 0);
		weekend.set(Calendar.MINUTE, 0);
		weekend.set(Calendar.HOUR_OF_DAY, 0);
		weekend.add(Calendar.DATE, -weekend.get(Calendar.DAY_OF_WEEK));
		return weekend;
	}
	
	public Date getReportingStartDate() {
		if (reportingStartDate == null) { 
			Calendar startDate = Calendar.getInstance();
			startDate.set(2006, 8, 3, 0, 0, 0);
			startDate.set(Calendar.MILLISECOND, 0);
			reportingStartDate = startDate.getTime();
		}
		return reportingStartDate;
	}
	
	/*
	 * TODO: THE FOLLOWING COMMENTED BLOCKS COULD BE RE-INTRODUCED BASED ON NEEDS YET
	 * TO BE DETERMINED ONCE WE START IMPLEMENTING REPORTS.
	 */
	
//	private List<DeviceTrackerLog> processDeviceTrackerLogs() throws ServiceException {
//		List<DeviceTrackerLog> results = new ArrayList<DeviceTrackerLog>();
//		logger.debug("processDeviceTrackerLogs list size:  " + results.size());
//		try {
//			List<Vendor> activeVendors = reportsDao.getActiveVendorsForComplianceReport();
//			List<DeviceTrackerLog> deviceTrackerLogs = reportsDao.getUnprocessedDeviceTrackerLogs();
//			if (deviceTrackerLogs.size() >= activeVendors.size()) {
//				results = deviceTrackerLogs;
//			} else {
//				this.logger.error("Active vendors have not reported in device tracker log table");
//			}
//
//		} catch (Exception e) {
//			throw new ServiceException(e.getMessage(), e);
//		}
//		return results;
//	}
	
//	private BufferedImage createChart(List<Object[]> data) {
//		// create chart for the lat week only
//		String MODEL_NAME = "Device Model";
//		String SERIAL_NUMBER = "Serial Number";
//
//		DefaultCategoryDataset dataset = new DefaultCategoryDataset();
//		Date reportEndDate = (Date) data.get(0)[0];
//		for (Object[] objs : data) {
//			if (reportEndDate.equals((Date) objs[0])) {
//				String vendorName = (String) objs[1];
//				Integer deviceCount = (Integer) objs[2];
//				Integer modelNameCount = (Integer) objs[3];
//				Integer serialNumberCount = (Integer) objs[4];
//				dataset.addValue(100.0 * modelNameCount / deviceCount, MODEL_NAME, vendorName);
//				dataset.addValue(100.0 * serialNumberCount / deviceCount, SERIAL_NUMBER, vendorName);
//			} else {
//				// we have collected last weeks data
//				break;
//			}
//		}
//
//		JFreeChart chart = ChartFactory.createBarChart(
//				"Device Model and Serial Number Vendor Compliance for the week ending "
//						+ DateUtils.format(reportEndDate, null), // chart title
//				"Vendor", // domain axis label
//				"Percent of Devices Reporting Serial Number/Device Model", dataset, // data
//				PlotOrientation.VERTICAL, // orientation
//				true, // include legend
//				true, // tooltips?
//				false // URLs?
//		);
//
//		// set the background color for the chart...
//		chart.setBackgroundPaint(Color.white);
//
//		// get a reference to the plot for further customisation...
//		CategoryPlot plot = (CategoryPlot) chart.getPlot();
//
//		// set the range axis to display integers only...
//		NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
//		rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
//
//		// disable bar outlines...
//		BarRenderer renderer = (BarRenderer) plot.getRenderer();
//		renderer.setDrawBarOutline(false);
//
//		// set up gradient paints for series...
//		GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, new Color(0, 0, 64));
//		GradientPaint gp1 = new GradientPaint(0.0f, 0.0f, Color.green, 0.0f, 0.0f, new Color(0, 64, 0));
//		renderer.setSeriesPaint(0, gp0);
//		renderer.setSeriesPaint(1, gp1);
//
//		// CategoryAxis domainAxis = plot.getDomainAxis();
//		// /domainAxis.setCategoryLabelPositions(
//		// /CategoryLabelPositions.createUpRotationLabelPositions(
//		// Math.PI / 6.0));
//		return chart.createBufferedImage(700, 700);
//	}
	
//	private void updateVendorComplianceReportCompletion(List<DeviceTrackerLog> results) throws ServiceException {
//		try {
//			reportsDao.setVendorComplianceReportCompletion(results);
//		} catch (Exception e) {
//			throw new ServiceException(e.getMessage(), e);
//		}
//	}
	
//	private void updateWeeklyVendorComplianceJob(boolean reset) throws ServiceException {
//		logger.error("$$$$$ fix me.");
//
//		try {
//			String defaultExp = "0 0 7 ? * MON *";
//			Trigger trigger = schedulingService.getTrigger("weeklyVendorComplianceReportCronTrigger",
//					"common.static.triggers");
//			String currentExp = ((CronTrigger) trigger).getCronExpression();
//			if (reset && !currentExp.equalsIgnoreCase(defaultExp)) {
//				logger.debug("resetting weeekly vendor compliance cron exp to:  " + defaultExp);
//				((CronTrigger) trigger).setCronExpression(defaultExp);
//				schedulingService.reschedule("weeklyVendorComplianceReportCronTrigger", "common.static.triggers",
//						(CronTrigger) trigger);
//			} else if (!reset) {
//				String nextCronExp = this.rescheduleCron(currentExp);
//				logger.debug("changing weeekly vendor compliance cron exp to:  " + nextCronExp);
//				((CronTrigger) trigger).setCronExpression(nextCronExp);
//				schedulingService.reschedule("weeklyVendorComplianceReportCronTrigger", "common.static.triggers",
//						(CronTrigger) trigger);
//			}
//		} catch (Exception e) {
//			throw new ServiceException(e.getMessage(), e);
//		}
//	}

}
