package gov.va.med.ccht.service.common;

public class UnknownTerminologyCodeException extends TerminologyException {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 1320716266505147123L;

	private String code = null;

	private Class dao = null;

	public UnknownTerminologyCodeException(String msg, String code, Class dao) {
		super(msg);
		this.code = code;
		this.dao = dao;
	}

	public String getMessage() {
		StringBuilder msg = new StringBuilder(super.getMessage());
		msg.append(" Code: ").append(code).append(" DAO: ").append(
				(dao != null) ? dao.getName() : null);

		return msg.toString();
	}

	public String getCode() {
		return code;
	}

	public Class getType() {
		return dao;
	}
}