/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common;

import java.util.List;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.terminology.FederalHoliday;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.ldap.LdapPerson;
import gov.va.med.fw.model.ldap.SearchCriteria;
import gov.va.med.fw.security.Permission;
import gov.va.med.fw.security.Role;
import gov.va.med.fw.security.SimpleRole;
import gov.va.med.fw.service.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 
 * Interface for Security Servies required by IHTA
 * 
 * IHTA IHTA_common Jun 24, 2010
 * 
 * @author DNS
 */
@Service
public interface SecurityService extends gov.va.med.fw.security.SecurityService {
	/**
	 * Get User by Name
	 * 
	 * @param userName
	 * @return
	 * @throws ServiceException
	 */
	public User getUser(String userName) throws ServiceException;

//	/**
//	 * Get User by Entity Key
//	 * 
//	 * @param entityKey
//	 * @return
//	 * @throws ServiceException
//	 */ TODO Figure out if this is used anywhere.
//	public User getUser(EntityKey<User> entityKey) throws ServiceException;
	public Role getRole(EntityKey<?> entityKey) throws ServiceException;
	
	public Role getRoleById(long id);
	
	public LdapPerson getLdapUser(String samAcountName) throws ServiceException;
	
	public Boolean authenticateLdapUser(String userDn, String password) throws ServiceException;
	
	/**
	 * Create user in IHTA database
	 * 
	 * @param user
	 * @throws ServiceException
	 */
	public void createUser(User user) throws ServiceException;

	/**
	 * update User
	 * 
	 * @param user
	 * @throws ServiceException
	 */
	public void updateUser(User user) throws ServiceException;

	/**
	 * update role
	 * 
	 * @param role
	 * @throws ServiceException
	 */
	public void updateRole(Role role) throws ServiceException;

	/**
	 * Delete a role from LDAP and IHTA Database
	 * 
	 * @param role
	 * @throws ServiceException
	 */
	public void deleteRole(Role role) throws ServiceException;

	/**
	 * Get list of available role names for granting this interface is for
	 * assigning the roles in LDAP which requires common name of roles
	 * 
	 * @throws ServiceException
	 */
//	public Set<String> getAvailableRoleNames(Application application) throws ServiceException;

//	public Set<String> getAvailableRoleNames() throws ServiceException;
	public List<SimpleRole> getAllSimpleRoles() throws ServiceException;
	
	public List<Role> getAllRoles() throws ServiceException;

	public List<FederalHoliday> getHolidays(int year) throws ServiceException;

	public List<Permission> getAllPermissions() throws ServiceException;

	public List<User> findAppUsers(SearchCriteria searchCriteria) throws ServiceException;

	public List<String> getUserIds() throws ServiceException;
	
	public List<User> getUsersByVisn(int visnId);
	
	public int updateUsers(List<String> userIds) throws ServiceException;
	public List<User> getSubmittedRegistrations(Integer visnId, Integer facilityId) throws ServiceException;
	public List<User> getNewRegistrations(Integer visnId, Integer facilityId) throws ServiceException;
	public List<SimpleRole> getAllDMPRoles() throws ServiceException;
	public List<User> getSubmittedRegistrationsForDmp(Integer visnId, Integer facilityId) throws ServiceException;
}
