package gov.va.med.ccht.persistent.utils;


import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.ccht.persistent.DeviceModalityDAO;

public class PSSReportUtils 
{
	public final static String DO_NOT_INCLUDE = "-2";
	public final static String ALL = "-1";
	public final static String IVR = "IVR";
	public final static String HOME_DEVICE = "Home Device";
	public final static String BROWSER = "Browser";
	
	@Autowired
	DeviceModalityDAO deviceModalityDao;

	public static String getModalityStringForGroupByClause(String modality)
	{
		StringBuilder modalityString = new StringBuilder();

		if (modality.equalsIgnoreCase(DO_NOT_INCLUDE))
		{
			modalityString.append(" ");
		}
		else if(modality.equalsIgnoreCase(ALL))
		{
			modalityString.append(", CASE Device.device_name WHEN 'IVR' THEN Device.device_name WHEN 'BROWSER' THEN Device.device_name ELSE 'Home Device' END ");
			modalityString.append(" HAVING (CASE Device.device_name WHEN 'IVR' THEN Device.device_name WHEN 'BROWSER' THEN Device.device_name ELSE 'Home Device' END is not null) ");
		}
		else
		{
			modalityString.append(", DEVICE_MODALITY_TYPE.NAME ");
		}

		return modalityString.toString();
	}
	
	public static String getModalityInString(String modality)
	{
		StringBuilder modalityString = new StringBuilder();

		if (modality.equalsIgnoreCase(DO_NOT_INCLUDE) || modality.equalsIgnoreCase(ALL))
		{
			modalityString.append(" ");
		}
		else
		{
			modalityString.append(" and Device.Device_Modality_Type_ID in (:modalityIdList) ");
		}
		
		return modalityString.toString();
		
	}
	
	public static String getModalityInnerJoinString(String modality)
	{
		StringBuilder modalityString = new StringBuilder();

		if (modality.equalsIgnoreCase(DO_NOT_INCLUDE) || modality.equalsIgnoreCase(ALL))
		{
			modalityString.append(" ");
		}
		else
		{
			modalityString.append(" INNER JOIN DEVICE_MODALITY_TYPE ON Device.Device_Modality_Type_ID = DEVICE_MODALITY_TYPE.ID ");
		}
		
		return modalityString.toString();
		
	}
	
	public static String getModalityString(String selectedModality)
	{
		StringBuilder modalityString = new StringBuilder();

		if (selectedModality.equalsIgnoreCase(DO_NOT_INCLUDE))
		{
			modalityString.append(" '' AS [Modality], ");
		}
		else if(selectedModality.equalsIgnoreCase(ALL))
		{
			modalityString.append(" CASE Device.device_name WHEN 'IVR' THEN Device.device_name WHEN 'BROWSER' THEN Device.device_name ELSE 'Home Device' END AS [Modality], ");		
		}
		else
		{
			modalityString.append(" DEVICE_MODALITY_TYPE.NAME AS [Modality], ");
		}
	

		return modalityString.toString(); 
	}
	
	public static String getSurveyIdClause(final int patientSatisfactionVersion)
	{
		StringBuilder qString = new StringBuilder();

		switch (patientSatisfactionVersion)
		{
		case 1:
			qString.append("AND (b.Survey_ID = 2) ");
			break;
		case 2:
			qString.append("AND (b.Survey_ID = 3) ");
			break;
		}

		return qString.toString();
	}
	
}
